/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain;

import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReactionRecorderState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionRecorderState.class);
    private static final int MAX_ACTION_COUNT = 100;
    private static boolean warningLogged = false;
    private final Deque<TriggerInvocationFrame> triggerInvocationFrameStack = new ArrayDeque<TriggerInvocationFrame>();

    ReactionRecorderState() {
    }

    boolean isInsideTrigger() {
        return !this.triggerInvocationFrameStack.isEmpty();
    }

    Observation currentTrigger() {
        if (this.triggerInvocationFrameStack.isEmpty()) {
            return null;
        }
        return this.triggerInvocationFrameStack.peek().trigger;
    }

    void enterTrigger(Observation trigger) {
        this.triggerInvocationFrameStack.push(TriggerInvocationFrame.of(trigger));
    }

    boolean exitTrigger() {
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            this.triggerInvocationFrameStack.pop();
        }
        return this.triggerInvocationFrameStack.isEmpty();
    }

    public void recordAction(Observation action) {
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            this.triggerInvocationFrameStack.peek().recordAction(action);
        }
    }

    public Reaction toReaction() {
        List<Observation> actions = List.of();
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            actions = List.copyOf(this.triggerInvocationFrameStack.peek().actions);
        }
        return new Reaction(this.currentTrigger(), actions);
    }

    private static class TriggerInvocationFrame {
        private Observation trigger;
        private SequencedSet<Observation> actions;

        void recordAction(Observation action) {
            if (this.actions.size() >= 100) {
                TriggerInvocationFrame.logWarningOnce(this.trigger);
                return;
            }
            this.actions.add(action);
        }

        private static void logWarningOnce(Observation trigger) {
            if (!warningLogged) {
                log.warn("Maximum action count of {} reached for trigger '{}'. Further actions will be ignored. This is logged only once.", (Object)100, (Object)trigger);
                warningLogged = true;
            }
        }

        static TriggerInvocationFrame of(Observation trigger) {
            return new TriggerInvocationFrame(trigger, new LinkedHashSet<Observation>());
        }

        @Generated
        public TriggerInvocationFrame(Observation trigger, SequencedSet<Observation> actions) {
            this.trigger = trigger;
            this.actions = actions;
        }
    }
}

