/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain.model;

import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.ObservationIds;
import java.util.List;

public record Reaction(Observation trigger, List<Observation> actions, String id) {
    public Reaction(Observation trigger, List<Observation> actions) {
        this(trigger, actions == null ? List.of() : actions, Reaction.createId(actions, trigger));
    }

    public static Reaction actionOnly(Observation action) {
        if (action == null) {
            throw new IllegalArgumentException("Action cannot be null for action-only reaction");
        }
        return new Reaction(null, List.of(action));
    }

    public boolean isTriggerOnly() {
        return this.actions.isEmpty();
    }

    public boolean isActionOnly() {
        return this.trigger == null;
    }

    public Observation getSingleAction() {
        if (!this.isActionOnly()) {
            throw new IllegalStateException("cannot get single action reaction - reaction is not action-only");
        }
        return this.actions.getFirst();
    }

    private static String createId(List<Observation> actions, Observation trigger) {
        if (trigger == null && (actions == null || actions.isEmpty())) {
            throw new IllegalArgumentException("Reaction must have at least an action or a trigger");
        }
        if (trigger == null) {
            return "#" + ObservationIds.actionIdsHash(actions);
        }
        if (actions == null || actions.isEmpty()) {
            return trigger.id().value();
        }
        return trigger.id().value() + "#" + ObservationIds.actionIdsHash(actions);
    }
}

