/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain;

import ch.admin.bit.jeap.reaction.observer.core.domain.ReactionObserverService;
import ch.admin.bit.jeap.reaction.observer.core.domain.ReactionRecorderState;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction;

public class ReactionRecorder {
    private final ReactionObserverService reactionObserverService;
    private final ThreadLocal<ReactionRecorderState> reactionRecorderState = ThreadLocal.withInitial(ReactionRecorderState::new);

    public ReactionRecorder(ReactionObserverService reactionObserverService) {
        this.reactionObserverService = reactionObserverService;
    }

    public void onAction(Observation action) {
        ReactionRecorderState state = this.reactionRecorderState.get();
        Observation trigger = state.currentTrigger();
        Reaction reaction = new Reaction(trigger, action);
        this.reactionObserverService.reactionObserved(reaction);
        state.notifyReactionPublished();
    }

    public void onTriggerStart(Observation trigger) {
        ReactionRecorderState state = this.reactionRecorderState.get();
        state.enterTrigger(trigger);
    }

    public void onTriggerHandled() {
        ReactionRecorderState state = this.reactionRecorderState.get();
        if (state.currentTrigger() != null && !state.isReactionPublished()) {
            Reaction reaction = new Reaction(state.currentTrigger(), null);
            this.reactionObserverService.reactionObserved(reaction);
            state.notifyReactionPublished();
        }
    }

    public void afterTrigger() {
        if (this.reactionRecorderState.get().exitTrigger()) {
            this.reactionRecorderState.remove();
        }
    }
}

