/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain;

import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import java.util.ArrayDeque;
import java.util.Deque;
import lombok.Generated;

class ReactionRecorderState {
    private final Deque<TriggerInvocationFrame> triggerInvocationFrameStack = new ArrayDeque<TriggerInvocationFrame>();

    ReactionRecorderState() {
    }

    Observation currentTrigger() {
        if (this.triggerInvocationFrameStack.isEmpty()) {
            return null;
        }
        return this.triggerInvocationFrameStack.peek().trigger;
    }

    public void notifyReactionPublished() {
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            this.triggerInvocationFrameStack.peek().reactionPublished = true;
        }
    }

    public boolean isReactionPublished() {
        return !this.triggerInvocationFrameStack.isEmpty() && this.triggerInvocationFrameStack.peek().reactionPublished;
    }

    void enterTrigger(Observation trigger) {
        this.triggerInvocationFrameStack.push(TriggerInvocationFrame.of(trigger));
    }

    boolean exitTrigger() {
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            this.triggerInvocationFrameStack.pop();
        }
        return this.triggerInvocationFrameStack.isEmpty();
    }

    private static class TriggerInvocationFrame {
        private Observation trigger;
        private boolean reactionPublished;

        static TriggerInvocationFrame of(Observation trigger) {
            return new TriggerInvocationFrame(trigger, false);
        }

        @Generated
        public TriggerInvocationFrame(Observation trigger, boolean reactionPublished) {
            this.trigger = trigger;
            this.reactionPublished = reactionPublished;
        }
    }
}

