/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain.model;

import ch.admin.bit.jeap.reaction.observer.core.domain.model.ObservationId;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.ObservationType;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.codec.digest.DigestUtils;

class ObservationIds {
    ObservationIds() {
    }

    static ObservationId create(ObservationType type, String fqn, SortedMap<String, String> props) {
        String value = ObservationIds.sanitize(type.name().toLowerCase()) + ":" + ObservationIds.sanitize(fqn) + ObservationIds.propsHash(props);
        return new ObservationId(value);
    }

    private static String propsHash(SortedMap<String, String> props) {
        if (props == null || props.isEmpty()) {
            return "";
        }
        StringBuilder hashedValue = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (!first) {
                hashedValue.append("&");
            }
            first = false;
            hashedValue.append(ObservationIds.sanitize(entry.getKey())).append("=").append(ObservationIds.sanitize(entry.getValue()));
        }
        return ":" + DigestUtils.md5Hex((String)hashedValue.toString());
    }

    private static String sanitize(String type) {
        return type.replace("#", "_").replace(":", "_");
    }
}

