/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain;

import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import lombok.Generated;

class ReactionRecorderState {
    private final Deque<TriggerInvocationFrame> triggerInvocationFrameStack = new ArrayDeque<TriggerInvocationFrame>();

    ReactionRecorderState() {
    }

    boolean isInsideTrigger() {
        return !this.triggerInvocationFrameStack.isEmpty();
    }

    Observation currentTrigger() {
        if (this.triggerInvocationFrameStack.isEmpty()) {
            return null;
        }
        return this.triggerInvocationFrameStack.peek().trigger;
    }

    void enterTrigger(Observation trigger) {
        this.triggerInvocationFrameStack.push(TriggerInvocationFrame.of(trigger));
    }

    boolean exitTrigger() {
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            this.triggerInvocationFrameStack.pop();
        }
        return this.triggerInvocationFrameStack.isEmpty();
    }

    public void recordAction(Observation action) {
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            this.triggerInvocationFrameStack.peek().recordAction(action);
        }
    }

    public Reaction toReaction() {
        List<Observation> actions = List.of();
        if (!this.triggerInvocationFrameStack.isEmpty()) {
            actions = this.triggerInvocationFrameStack.peek().actions;
        }
        return new Reaction(this.currentTrigger(), actions);
    }

    private static class TriggerInvocationFrame {
        private Observation trigger;
        private List<Observation> actions;

        void recordAction(Observation action) {
            this.actions.add(action);
        }

        static TriggerInvocationFrame of(Observation trigger) {
            return new TriggerInvocationFrame(trigger, new ArrayList<Observation>());
        }

        @Generated
        public TriggerInvocationFrame(Observation trigger, List<Observation> actions) {
            this.trigger = trigger;
            this.actions = actions;
        }
    }
}

