/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain.model;

import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.ObservationId;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.ObservationType;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

class ObservationIds {
    ObservationIds() {
    }

    static ObservationId create(ObservationType type, String fqn, SortedMap<String, String> props) {
        String value = ObservationIds.sanitize(type.name().toLowerCase()) + ":" + ObservationIds.sanitize(fqn) + ObservationIds.propsHash(props);
        return new ObservationId(value);
    }

    static String actionIdsHash(List<Observation> actions) {
        String actionIds = actions.stream().map(observation -> observation.id().value()).sorted().collect(Collectors.joining("&"));
        return DigestUtils.md5Hex((String)actionIds);
    }

    private static String propsHash(SortedMap<String, String> props) {
        if (props == null || props.isEmpty()) {
            return "";
        }
        if (props.size() == 1) {
            Map.Entry entry = props.firstEntry();
            return ":" + DigestUtils.md5Hex((String)(ObservationIds.sanitize((String)entry.getKey()) + "=" + ObservationIds.sanitize((String)entry.getValue())));
        }
        StringBuilder concatenatedProps = ObservationIds.concatenateSanitizedProps(props);
        return ":" + DigestUtils.md5Hex((String)concatenatedProps.toString());
    }

    private static StringBuilder concatenateSanitizedProps(SortedMap<String, String> props) {
        StringBuilder concatenatedProps = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (!first) {
                concatenatedProps.append("&");
            }
            first = false;
            concatenatedProps.append(ObservationIds.sanitize(entry.getKey())).append("=").append(ObservationIds.sanitize(entry.getValue()));
        }
        return concatenatedProps;
    }

    private static String sanitize(String type) {
        return type.replace("#", "_").replace(":", "_");
    }
}

