/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.domain;

import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Action;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Edge;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Reaction;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Trigger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class GraphExtractor {
    public Graph getSystemRelatedGraph(Graph graph, String systemName) {
        List<Reaction> relevantReactions = graph.nodes().stream().filter(node -> {
            Reaction reaction;
            return node instanceof Reaction && (reaction = (Reaction)node).system().equals(systemName);
        }).map(node -> (Reaction)node).toList();
        List<Edge> relevantEdges = graph.edges().stream().filter(edge -> {
            if (edge instanceof Trigger) {
                Trigger trigger = (Trigger)edge;
                return relevantReactions.contains(trigger.target());
            }
            if (edge instanceof Action) {
                Action action = (Action)edge;
                return relevantReactions.contains(action.source());
            }
            return false;
        }).toList();
        Set relevantMessages = relevantEdges.stream().flatMap(edge -> {
            if (edge instanceof Trigger) {
                Trigger trigger = (Trigger)edge;
                return Stream.of(trigger.source());
            }
            if (edge instanceof Action) {
                Action action = (Action)edge;
                return Stream.of(action.target());
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        HashSet<Reaction> relevantNodes = new HashSet<Reaction>(relevantReactions);
        relevantNodes.addAll(relevantMessages);
        return new Graph(List.copyOf(relevantNodes), relevantEdges);
    }
}

