/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.domain;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionsAggregatedRepository;
import ch.admin.bit.jeap.reaction.observer.domain.ReactionGraphRepository;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Edge;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Trigger;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReactionGraphBuilderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionGraphBuilderService.class);
    private final ReactionGraphRepository graphRepository;
    private final ObservedReactionsAggregatedRepository observedReactionsAggregatedRepository;

    public Graph buildGraph(LocalDate fromDate) {
        Graph graph = this.graphRepository.buildFullGraph();
        if (graph == null) {
            log.warn("No graph could be built from the repository. Returning empty graph.");
            return new Graph(List.of(), List.of());
        }
        Map<Long, Integer> medians = this.observedReactionsAggregatedRepository.getMedianPerReaction(fromDate);
        List<Edge> enrichedEdges = graph.edges().stream().map(edge -> {
            if (edge instanceof Trigger) {
                Trigger trigger = (Trigger)edge;
                Long reactionId = trigger.target().getId();
                Integer median = medians.getOrDefault(reactionId, null);
                return Trigger.builder().source(trigger.source()).target(trigger.target()).median(median).build();
            }
            return edge;
        }).toList();
        return new Graph(graph.nodes(), enrichedEdges);
    }

    @Generated
    public ReactionGraphBuilderService(ReactionGraphRepository graphRepository, ObservedReactionsAggregatedRepository observedReactionsAggregatedRepository) {
        this.graphRepository = graphRepository;
        this.observedReactionsAggregatedRepository = observedReactionsAggregatedRepository;
    }
}

