/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.domain;

import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Action;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Edge;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Message;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Node;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Reaction;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Trigger;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphExtractor.class);

    public Graph getSystemRelatedGraph(Graph graph, String systemName) {
        return this.getFilteredGraph(graph, reaction -> reaction.system() != null && reaction.system().equalsIgnoreCase(systemName));
    }

    public Graph getComponentRelatedGraph(Graph graph, String componentName) {
        return this.getFilteredGraph(graph, reaction -> reaction.component().equals(componentName));
    }

    public Graph getMessageRelatedGraph(Graph graph, String messageType, String variant) {
        Optional<Message> messageOpt = graph.nodes().stream().filter(node -> {
            Message message;
            return node instanceof Message && (message = (Message)node).messageType().equals(messageType) && Objects.equals(message.variant(), variant);
        }).map(node -> (Message)node).findFirst();
        if (messageOpt.isEmpty()) {
            log.warn("No matching message found for type='{}' and variant='{}'. Returning empty graph.", (Object)messageType, (Object)variant);
            return new Graph(List.of(), List.of());
        }
        Message message = messageOpt.get();
        List<Trigger> outgoingTriggers = graph.edges().stream().filter(edge -> {
            Trigger trigger;
            return edge instanceof Trigger && (trigger = (Trigger)edge).source().equals(message);
        }).map(edge -> (Trigger)edge).toList();
        List<Action> incomingActions = graph.edges().stream().filter(edge -> {
            Action action;
            return edge instanceof Action && (action = (Action)edge).target().equals(message);
        }).map(edge -> (Action)edge).toList();
        Set<Node> relatedReactions = Stream.concat(outgoingTriggers.stream().map(Trigger::target), incomingActions.stream().map(Action::source)).collect(Collectors.toSet());
        Set<Node> adjacentMessages = this.getAdjacentMessagesForReactions(graph, relatedReactions);
        HashSet<Node> relevantNodes = new HashSet<Node>();
        relevantNodes.add(message);
        relevantNodes.addAll(relatedReactions);
        relevantNodes.addAll(adjacentMessages);
        List<Edge> relevantEdges = graph.edges().stream().filter(edge -> {
            if (edge instanceof Trigger) {
                Trigger trigger = (Trigger)edge;
                return relevantNodes.contains(trigger.source()) && relevantNodes.contains(trigger.target());
            }
            if (edge instanceof Action) {
                Action action = (Action)edge;
                return relevantNodes.contains(action.source()) && relevantNodes.contains(action.target());
            }
            return false;
        }).toList();
        return new Graph(List.copyOf(relevantNodes), relevantEdges);
    }

    private Set<Node> getAdjacentMessagesForReactions(Graph graph, Set<Node> reactions) {
        return reactions.stream().flatMap(reactionNode -> {
            Reaction reaction = (Reaction)reactionNode;
            Stream<Node> triggerSources = graph.edges().stream().filter(edge -> {
                Trigger trigger;
                return edge instanceof Trigger && (trigger = (Trigger)edge).target().equals(reaction);
            }).map(edge -> ((Trigger)edge).source());
            Stream<Node> actionTargets = graph.edges().stream().filter(edge -> {
                Action action;
                return edge instanceof Action && (action = (Action)edge).source().equals(reaction);
            }).map(edge -> ((Action)edge).target());
            return Stream.concat(triggerSources, actionTargets);
        }).collect(Collectors.toSet());
    }

    public Graph getFilteredGraph(Graph graph, Predicate<Reaction> reactionFilter) {
        List<Reaction> relevantReactions = graph.nodes().stream().filter(node -> {
            Reaction reaction;
            return node instanceof Reaction && reactionFilter.test(reaction = (Reaction)node);
        }).map(node -> (Reaction)node).toList();
        if (relevantReactions.isEmpty()) {
            log.warn("No reactions found for filter. Returning empty graph.");
            return new Graph(List.of(), List.of());
        }
        List<Edge> relevantEdges = graph.edges().stream().filter(edge -> {
            if (edge instanceof Trigger) {
                Trigger trigger = (Trigger)edge;
                return relevantReactions.contains(trigger.target());
            }
            if (edge instanceof Action) {
                Action action = (Action)edge;
                return relevantReactions.contains(action.source());
            }
            return false;
        }).toList();
        Set relevantMessages = relevantEdges.stream().flatMap(edge -> {
            if (edge instanceof Trigger) {
                Trigger trigger = (Trigger)edge;
                return Stream.of(trigger.source());
            }
            if (edge instanceof Action) {
                Action action = (Action)edge;
                return Stream.of(action.target());
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
        HashSet<Reaction> relevantNodes = new HashSet<Reaction>(relevantReactions);
        relevantNodes.addAll(relevantMessages);
        return new Graph(List.copyOf(relevantNodes), relevantEdges);
    }
}

