/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.events.producer;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.reaction.observer.core.domain.listener.ReactionIdentifiedListener;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedMessageKey;
import ch.admin.bit.jeap.reaction.observer.event.observed.ReactionsObservedEvent;
import ch.admin.bit.jeap.reaction.observer.events.producer.ReactionIdentifiedEventBuilder;
import ch.admin.bit.jeap.reaction.observer.events.producer.ReactionObserverKafkaException;
import ch.admin.bit.jeap.reaction.observer.events.producer.ReactionsObservedEventBuilder;
import ch.admin.bit.jeap.reaction.observer.events.spring.ReactionObserverKafkaConfigProperties;
import com.fasterxml.uuid.Generators;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.StringUtils;

public class KafkaEventProducer
implements ReactionIdentifiedListener {
    private final KafkaProperties kafkaProperties;
    private final ReactionObserverKafkaConfigProperties config;
    private final KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate;
    private final UUID serviceInstanceIdentifier = Generators.timeBasedEpochGenerator().generate();

    public KafkaEventProducer(KafkaProperties kafkaProperties, ReactionObserverKafkaConfigProperties config, KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate) {
        this.kafkaProperties = kafkaProperties;
        this.config = config;
        this.kafkaTemplate = kafkaTemplate;
    }

    @PostConstruct
    public void init() {
        if (!StringUtils.hasText((String)this.kafkaProperties.getSystemName())) {
            throw new IllegalArgumentException("System name is required");
        }
        if (!StringUtils.hasText((String)this.kafkaProperties.getServiceName())) {
            throw new IllegalArgumentException("Service name is required");
        }
    }

    public void onReactionIdentified(Reaction reaction) {
        ReactionIdentifiedEvent event = ReactionIdentifiedEventBuilder.buildEvent(this.kafkaProperties.getSystemName(), this.kafkaProperties.getServiceName(), reaction);
        this.sendSync(this.config.getReactionIdentifiedTopic(), KafkaEventProducer.createKey(reaction), (AvroMessage)event);
    }

    public void sendReactionObservedEvent(Map<String, AtomicInteger> countByReactionId, Instant from, Instant to) {
        ReactionsObservedEvent event = new ReactionsObservedEventBuilder(this.kafkaProperties.getSystemName(), this.kafkaProperties.getServiceName()).serviceInstanceIdentifier(this.serviceInstanceIdentifier).countByReactionId(countByReactionId).timeframe(from, to).build();
        this.sendSync(this.config.getReactionsObservedTopic(), null, (AvroMessage)event);
    }

    private void sendSync(String topic, AvroMessageKey key, AvroMessage message) {
        try {
            this.kafkaTemplate.send(topic, (Object)key, (Object)message).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ReactionObserverKafkaException.producingEventFailed(e);
        }
        catch (ExecutionException e) {
            throw ReactionObserverKafkaException.producingEventFailed(e);
        }
    }

    private static AvroMessageKey createKey(Reaction reaction) {
        return new ReactionIdentifiedMessageKey(reaction.id());
    }
}

