/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.events.producer;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import ch.admin.bit.jeap.reaction.observer.event.identified.ActionOnly;
import ch.admin.bit.jeap.reaction.observer.event.identified.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedPayload;
import ch.admin.bit.jeap.reaction.observer.event.identified.TriggerOnly;
import java.util.Map;

public class ReactionIdentifiedEventBuilder
extends AvroDomainEventBuilder<ReactionIdentifiedEventBuilder, ReactionIdentifiedEvent> {
    private final String serviceName;
    private final String systemName;
    private ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction reaction;

    public static ReactionIdentifiedEvent buildEvent(String systemName, String serviceName, ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction reaction) {
        ReactionIdentifiedEventBuilder builder = new ReactionIdentifiedEventBuilder(serviceName, systemName);
        builder.setReaction(reaction);
        return builder.build();
    }

    private void setReaction(ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction reaction) {
        if (reaction.action() == null && reaction.trigger() == null) {
            throw new IllegalArgumentException("Reaction must have at least an action or a trigger");
        }
        this.reaction = reaction;
        this.idempotenceId("ri_" + reaction.id());
    }

    private ReactionIdentifiedEventBuilder(String serviceName, String systemName) {
        super(ReactionIdentifiedEvent::new);
        this.serviceName = serviceName;
        this.systemName = systemName;
    }

    public ReactionIdentifiedEvent build() {
        TriggerOnly reactionPayload;
        if (this.reaction.action() == null) {
            ch.admin.bit.jeap.reaction.observer.event.identified.Observation observation = this.createObservation(this.reaction.trigger());
            reactionPayload = new TriggerOnly(observation);
        } else if (this.reaction.trigger() == null) {
            ch.admin.bit.jeap.reaction.observer.event.identified.Observation observation = this.createObservation(this.reaction.action());
            reactionPayload = new ActionOnly(observation);
        } else {
            reactionPayload = new Reaction(this.createObservation(this.reaction.trigger()), this.createObservation(this.reaction.action()));
        }
        this.setPayload((MessagePayload)new ReactionIdentifiedPayload(this.reaction.id(), (Object)reactionPayload));
        return (ReactionIdentifiedEvent)super.build();
    }

    private ch.admin.bit.jeap.reaction.observer.event.identified.Observation createObservation(Observation observation) {
        Map props = observation.props();
        if (props == null) {
            props = Map.of();
        }
        return new ch.admin.bit.jeap.reaction.observer.event.identified.Observation(observation.type().name().toLowerCase(), observation.fqn(), props);
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected String getSystemName() {
        return this.systemName;
    }

    protected ReactionIdentifiedEventBuilder self() {
        return this;
    }
}

