/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.events.spring;

import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="jeap.reaction.observer.events")
@Validated
public class ReactionObserverKafkaConfigProperties
implements EnvironmentAware {
    private String reactionIdentifiedTopic;
    private String reactionsObservedTopic;
    private int observedEventRateSeconds = 300;
    private Environment environment;

    public boolean isObservedEventSchedulingEnabled() {
        return this.observedEventRateSeconds > 0;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    public void validate() {
        if (((Boolean)this.environment.getProperty("jeap.reaction.observer.enabled", Boolean.class, (Object)true)).booleanValue()) {
            if (this.reactionIdentifiedTopic == null || this.reactionIdentifiedTopic.isEmpty()) {
                throw new IllegalArgumentException("jeap.reaction.observer.events.reaction-identified-topic must not be empty");
            }
            if (this.reactionsObservedTopic == null || this.reactionsObservedTopic.isEmpty()) {
                throw new IllegalArgumentException("jeap.reaction.observer.events.reactions-observed-topic must not be empty");
            }
        }
    }

    @Generated
    public ReactionObserverKafkaConfigProperties() {
    }

    @Generated
    public String getReactionIdentifiedTopic() {
        return this.reactionIdentifiedTopic;
    }

    @Generated
    public String getReactionsObservedTopic() {
        return this.reactionsObservedTopic;
    }

    @Generated
    public int getObservedEventRateSeconds() {
        return this.observedEventRateSeconds;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public void setReactionIdentifiedTopic(String reactionIdentifiedTopic) {
        this.reactionIdentifiedTopic = reactionIdentifiedTopic;
    }

    @Generated
    public void setReactionsObservedTopic(String reactionsObservedTopic) {
        this.reactionsObservedTopic = reactionsObservedTopic;
    }

    @Generated
    public void setObservedEventRateSeconds(int observedEventRateSeconds) {
        this.observedEventRateSeconds = observedEventRateSeconds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactionObserverKafkaConfigProperties)) {
            return false;
        }
        ReactionObserverKafkaConfigProperties other = (ReactionObserverKafkaConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getObservedEventRateSeconds() != other.getObservedEventRateSeconds()) {
            return false;
        }
        String this$reactionIdentifiedTopic = this.getReactionIdentifiedTopic();
        String other$reactionIdentifiedTopic = other.getReactionIdentifiedTopic();
        if (this$reactionIdentifiedTopic == null ? other$reactionIdentifiedTopic != null : !this$reactionIdentifiedTopic.equals(other$reactionIdentifiedTopic)) {
            return false;
        }
        String this$reactionsObservedTopic = this.getReactionsObservedTopic();
        String other$reactionsObservedTopic = other.getReactionsObservedTopic();
        if (this$reactionsObservedTopic == null ? other$reactionsObservedTopic != null : !this$reactionsObservedTopic.equals(other$reactionsObservedTopic)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReactionObserverKafkaConfigProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getObservedEventRateSeconds();
        String $reactionIdentifiedTopic = this.getReactionIdentifiedTopic();
        result = result * 59 + ($reactionIdentifiedTopic == null ? 43 : $reactionIdentifiedTopic.hashCode());
        String $reactionsObservedTopic = this.getReactionsObservedTopic();
        result = result * 59 + ($reactionsObservedTopic == null ? 43 : $reactionsObservedTopic.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReactionObserverKafkaConfigProperties(reactionIdentifiedTopic=" + this.getReactionIdentifiedTopic() + ", reactionsObservedTopic=" + this.getReactionsObservedTopic() + ", observedEventRateSeconds=" + this.getObservedEventRateSeconds() + ", environment=" + String.valueOf(this.getEnvironment()) + ")";
    }
}

