/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.events.producer;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ActionOnly;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.Observation;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ReactionIdentifiedPayload;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.TriggerOnly;
import java.util.List;
import java.util.Map;

public class ReactionIdentifiedEventBuilder
extends AvroDomainEventBuilder<ReactionIdentifiedEventBuilder, ReactionIdentifiedEvent> {
    private final String serviceName;
    private final String systemName;
    private ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction reaction;

    public static ReactionIdentifiedEvent buildEvent(String systemName, String serviceName, ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction reaction) {
        ReactionIdentifiedEventBuilder builder = new ReactionIdentifiedEventBuilder(serviceName, systemName);
        builder.setReaction(reaction);
        return builder.build();
    }

    private void setReaction(ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction reaction) {
        this.reaction = reaction;
        this.idempotenceId("ri_" + this.serviceName + "_" + reaction.id());
    }

    private ReactionIdentifiedEventBuilder(String serviceName, String systemName) {
        super(ReactionIdentifiedEvent::new);
        this.serviceName = serviceName;
        this.systemName = systemName;
    }

    public ReactionIdentifiedEvent build() {
        TriggerOnly reactionPayload;
        if (this.reaction.isTriggerOnly()) {
            Observation observation = this.createObservation(this.reaction.trigger());
            reactionPayload = new TriggerOnly(this.reaction.id(), observation);
        } else if (this.reaction.isActionOnly()) {
            Observation observation = this.createObservation(this.reaction.getSingleAction());
            reactionPayload = new ActionOnly(this.reaction.id(), observation);
        } else {
            List<Observation> actions = this.createObservations(this.reaction.actions());
            reactionPayload = new Reaction(this.reaction.id(), this.createObservation(this.reaction.trigger()), actions);
        }
        this.setPayload((MessagePayload)new ReactionIdentifiedPayload((Object)reactionPayload));
        return (ReactionIdentifiedEvent)super.build();
    }

    private List<Observation> createObservations(List<ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation> actions) {
        if (actions == null || actions.isEmpty()) {
            return List.of();
        }
        if (actions.size() == 1) {
            return List.of(this.createObservation(actions.getFirst()));
        }
        return actions.stream().map(this::createObservation).toList();
    }

    private Observation createObservation(ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation observation) {
        Map props = observation.props();
        if (props == null) {
            props = Map.of();
        }
        return new Observation(observation.id().value(), observation.type().name().toLowerCase(), observation.fqn(), props);
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected String getSystemName() {
        return this.systemName;
    }

    protected ReactionIdentifiedEventBuilder self() {
        return this;
    }
}

