/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.events.scheduler;

import ch.admin.bit.jeap.reaction.observer.core.domain.ReactionObserverService;
import ch.admin.bit.jeap.reaction.observer.events.producer.KafkaEventProducer;
import ch.admin.bit.jeap.reaction.observer.events.spring.ReactionObserverKafkaConfigProperties;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;

public class ReactionsObservedEventScheduler
implements SmartLifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionsObservedEventScheduler.class);
    private final ReactionObserverKafkaConfigProperties props;
    private final ReactionObserverService reactionObserverService;
    private final KafkaEventProducer kafkaEventProducer;
    private Instant lastObservationTimeframeStart;
    private boolean running = false;

    public ReactionsObservedEventScheduler(ReactionObserverKafkaConfigProperties props, ReactionObserverService reactionObserverService, KafkaEventProducer kafkaEventProducer) {
        this.props = props;
        this.reactionObserverService = reactionObserverService;
        this.kafkaEventProducer = kafkaEventProducer;
    }

    @Scheduled(fixedRateString="${jeap.reaction.observer.events.observed-event-rate-seconds:300}", initialDelayString="${jeap.reaction.observer.events.observed-event-rate-seconds:300}", timeUnit=TimeUnit.SECONDS)
    public void sendEvent() {
        if (this.running) {
            Instant to;
            Instant from = this.lastObservationTimeframeStart;
            this.lastObservationTimeframeStart = to = Instant.now();
            this.produceEvent(from, to);
        }
    }

    private void produceEvent(Instant from, Instant to) {
        Map countByReactionId = this.reactionObserverService.getAndClearCountByReactionId();
        if (countByReactionId.isEmpty()) {
            log.trace("No reactions observed in last timeframe. Skipping event production.");
            return;
        }
        log.debug("Producing ReactionsObserved events for timeframe from {} to {}: {}", new Object[]{from, to, countByReactionId});
        this.kafkaEventProducer.sendReactionObservedEvent(countByReactionId, from, to);
    }

    public void start() {
        if (!this.props.isObservedEventSchedulingEnabled()) {
            log.info("ReactionsObservedEventScheduler is disabled. Skipping start.");
            return;
        }
        log.info("Starting ReactionsObservedEventScheduler");
        if (this.lastObservationTimeframeStart == null) {
            this.lastObservationTimeframeStart = Instant.now();
        }
        this.running = true;
    }

    public void stop() {
        if (!this.props.isObservedEventSchedulingEnabled()) {
            return;
        }
        log.info("Stopping ReactionsObservedEventScheduler");
        this.sendEvent();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

