/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.kafka;

import ch.admin.bit.jeap.reaction.observer.domain.Observation;
import ch.admin.bit.jeap.reaction.observer.domain.Reaction;
import ch.admin.bit.jeap.reaction.observer.domain.ReactionRepository;
import ch.admin.bit.jeap.reaction.observer.event.identified.ActionOnly;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.TriggerOnly;
import java.lang.runtime.SwitchBootstraps;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;

class ReactionIdentifiedEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionIdentifiedEventListener.class);
    private final ReactionRepository reactionRepository;

    ReactionIdentifiedEventListener(ReactionRepository reactionRepository) {
        this.reactionRepository = reactionRepository;
    }

    @KafkaListener(topics={"${jeap.reaction.observer.service.kafka.reaction-identified-topic}"})
    public void onReactionIdentifiedEvent(ReactionIdentifiedEvent event) {
        Reaction reaction = ReactionIdentifiedEventListener.createReaction(event);
        log.debug("Identified reaction: {}", (Object)reaction);
        this.reactionRepository.save(reaction);
    }

    private static Reaction createReaction(ReactionIdentifiedEvent event) {
        Object reactionPayload = event.getPayload().getReaction();
        ch.admin.bit.jeap.reaction.observer.event.identified.Observation action = null;
        ch.admin.bit.jeap.reaction.observer.event.identified.Observation trigger = null;
        Object object = reactionPayload;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ch.admin.bit.jeap.reaction.observer.event.identified.Reaction.class, TriggerOnly.class, ActionOnly.class}, (Object)object2, n)) {
            case 0: {
                ch.admin.bit.jeap.reaction.observer.event.identified.Reaction reaction = (ch.admin.bit.jeap.reaction.observer.event.identified.Reaction)object2;
                action = reaction.getAction();
                trigger = reaction.getTrigger();
                break;
            }
            case 1: {
                TriggerOnly triggerOnly = (TriggerOnly)object2;
                trigger = triggerOnly.getTrigger();
                break;
            }
            case 2: {
                ActionOnly actionOnly = (ActionOnly)object2;
                action = actionOnly.getAction();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown reaction payload type: " + String.valueOf(reactionPayload.getClass()));
            }
        }
        return ReactionIdentifiedEventListener.createReaction(event, trigger, action);
    }

    private static Reaction createReaction(ReactionIdentifiedEvent event, ch.admin.bit.jeap.reaction.observer.event.identified.Observation trigger, ch.admin.bit.jeap.reaction.observer.event.identified.Observation action) {
        return new Reaction(event.getPublisher().getService(), event.getPayload().getReactionId(), ReactionIdentifiedEventListener.toDomainObservation(trigger), ReactionIdentifiedEventListener.toDomainObservation(action), ZonedDateTime.ofInstant(event.getIdentity().getCreated(), ZoneId.systemDefault()));
    }

    private static Observation toDomainObservation(ch.admin.bit.jeap.reaction.observer.event.identified.Observation trigger) {
        if (trigger == null) {
            return null;
        }
        return new Observation(trigger.getType(), trigger.getFqn(), trigger.getProps());
    }
}

