/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.kafka;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReaction;
import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionRepository;
import ch.admin.bit.jeap.reaction.observer.event.observed.Observation;
import ch.admin.bit.jeap.reaction.observer.event.observed.ReactionsObservedEvent;
import ch.admin.bit.jeap.reaction.observer.event.observed.Timeframe;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;

class ReactionsObservedEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionsObservedEventListener.class);
    private final ObservedReactionRepository observedReactionRepository;

    ReactionsObservedEventListener(ObservedReactionRepository observedReactionRepository) {
        this.observedReactionRepository = observedReactionRepository;
    }

    @KafkaListener(topics={"${jeap.reaction.observer.service.kafka.reactions-observed-topic}"})
    public void onReactionsObservedEvent(ReactionsObservedEvent event, Acknowledgment ack) {
        List<ObservedReaction> observedReactions = this.toObservedReactions(event);
        log.debug("Observed reactions: {}", observedReactions);
        this.observedReactionRepository.saveAll(event.getIdentity().getIdempotenceId(), observedReactions);
        ack.acknowledge();
    }

    private List<ObservedReaction> toObservedReactions(ReactionsObservedEvent event) {
        return event.getPayload().getObservations().stream().map(observation -> this.toDomainObject(event, (Observation)observation)).toList();
    }

    private ObservedReaction toDomainObject(ReactionsObservedEvent event, Observation observation) {
        Timeframe timeframe = event.getPayload().getTimeframe();
        String component = event.getPublisher().getService();
        return new ObservedReaction(component, observation.getReactionId(), ch.admin.bit.jeap.reaction.observer.domain.Timeframe.ofInstantsInDefaultTimezone((Instant)timeframe.getStart(), (Instant)timeframe.getEnd()), observation.getCount());
    }
}

