/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.kafka;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.reaction.observer.domain.ReactionRepository;
import ch.admin.bit.jeap.reaction.observer.domain.models.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ActionOnly;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.Observation;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.TriggerOnly;
import java.lang.runtime.SwitchBootstraps;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;

class ReactionIdentifiedEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionIdentifiedEventListener.class);
    private final ReactionRepository reactionRepository;

    ReactionIdentifiedEventListener(ReactionRepository reactionRepository) {
        this.reactionRepository = reactionRepository;
    }

    @KafkaListener(topics={"${jeap.reaction.observer.service.kafka.reaction-identified-topic}"})
    public void onReactionIdentifiedEvent(AvroMessage event, Acknowledgment ack) {
        if (event instanceof ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedEvent) {
            log.trace("Received a v1 ReactionIdentifiedEvent, which is not supported by this listener anymore. Ignoring event: {}", (Object)event);
            ack.acknowledge();
            return;
        }
        Reaction reaction = ReactionIdentifiedEventListener.createReaction((ReactionIdentifiedEvent)event);
        log.debug("Identified reaction: {}", (Object)reaction);
        this.reactionRepository.save(reaction);
        ack.acknowledge();
    }

    private static Reaction createReaction(ReactionIdentifiedEvent event) {
        String reactionId;
        Object reactionPayload = event.getPayload().getReaction();
        List<Observation> actions = null;
        Observation trigger = null;
        Object object = reactionPayload;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ch.admin.bit.jeap.reaction.observer.event.identified.v2.Reaction.class, TriggerOnly.class, ActionOnly.class}, (Object)object2, n)) {
            case 0: {
                ch.admin.bit.jeap.reaction.observer.event.identified.v2.Reaction reaction = (ch.admin.bit.jeap.reaction.observer.event.identified.v2.Reaction)object2;
                reactionId = reaction.getReactionId();
                actions = reaction.getActions();
                trigger = reaction.getTrigger();
                break;
            }
            case 1: {
                TriggerOnly triggerOnly = (TriggerOnly)object2;
                reactionId = triggerOnly.getReactionId();
                trigger = triggerOnly.getTrigger();
                break;
            }
            case 2: {
                ActionOnly actionOnly = (ActionOnly)object2;
                reactionId = actionOnly.getReactionId();
                actions = List.of(actionOnly.getAction());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown reaction payload type: " + String.valueOf(reactionPayload.getClass()));
            }
        }
        return ReactionIdentifiedEventListener.createReaction(event, reactionId, trigger, actions);
    }

    private static Reaction createReaction(ReactionIdentifiedEvent event, String reactionId, Observation trigger, List<Observation> actions) {
        return new Reaction(event.getPublisher().getSystem(), event.getPublisher().getService(), reactionId, ReactionIdentifiedEventListener.toDomainObservation(trigger), ReactionIdentifiedEventListener.toDomainObservationList(actions), ZonedDateTime.ofInstant(event.getIdentity().getCreated(), ZoneId.systemDefault()));
    }

    private static ch.admin.bit.jeap.reaction.observer.domain.models.Observation toDomainObservation(Observation observation) {
        if (observation == null) {
            return null;
        }
        return new ch.admin.bit.jeap.reaction.observer.domain.models.Observation(observation.getId(), observation.getType(), observation.getFqn(), observation.getProps());
    }

    private static List<ch.admin.bit.jeap.reaction.observer.domain.models.Observation> toDomainObservationList(List<Observation> observations) {
        if (observations == null || observations.isEmpty()) {
            return List.of();
        }
        return observations.stream().map(ReactionIdentifiedEventListener::toDomainObservation).toList();
    }
}

