/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.messaging;

import ch.admin.bit.jeap.command.Command;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedEvent;
import ch.admin.bit.jeap.messaging.kafka.interceptor.JeapKafkaMessageCallback;
import ch.admin.bit.jeap.messaging.model.Message;
import ch.admin.bit.jeap.reaction.observer.core.domain.ReactionRecorder;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Observation;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.observed.ReactionsObservedEvent;

public class ObserverKafkaMessageCallback
implements JeapKafkaMessageCallback {
    private final ReactionRecorder reactionRecorder;

    public ObserverKafkaMessageCallback(ReactionRecorder reactionRecorder) {
        this.reactionRecorder = reactionRecorder;
    }

    public void onSend(Message message, String topicName) {
        if (this.filtered(message)) {
            return;
        }
        Observation action = this.createObservation(message, topicName);
        this.reactionRecorder.onAction(action);
    }

    public void beforeConsume(Message message, String topicName) {
        if (this.filtered(message)) {
            return;
        }
        this.reactionRecorder.onTriggerStart(this.createObservation(message, topicName));
    }

    public void afterConsume(Message message, String topicName) {
        if (this.filtered(message)) {
            return;
        }
        this.reactionRecorder.onTriggerHandled();
    }

    public void afterRecord(Message message, String topicName) {
        if (this.filtered(message)) {
            return;
        }
        this.reactionRecorder.afterTrigger();
    }

    private Observation createObservation(Message message, String topicName) {
        String messageType = message.getType().getName();
        return message instanceof Command ? Observation.ofCommand((String)messageType, (String)topicName) : Observation.ofEvent((String)messageType, (String)topicName);
    }

    private boolean filtered(Message message) {
        return message instanceof ReactionsObservedEvent || message instanceof ReactionIdentifiedEvent || message instanceof MessageProcessingFailedEvent;
    }
}

