/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(name="reaction")
class ReactionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="reaction_sequence")
    @SequenceGenerator(name="reaction_sequence", sequenceName="reaction_sequence", allocationSize=10)
    @Column(name="id")
    private Long id;
    @Column(name="reaction_id")
    private String reactionId;
    @Column(name="component")
    private String component;
    @Column(name="trigger_id")
    private String triggerId;
    @Column(name="trigger_type")
    private String triggerType;
    @Column(name="trigger_fqn")
    private String triggerFqn;
    @Column(name="action_id")
    private String actionId;
    @Column(name="action_type")
    private String actionType;
    @Column(name="action_fqn")
    private String actionFqn;
    @Column(name="identified_at")
    private ZonedDateTime identifiedAt;

    private ReactionEntity(@NonNull String reactionId, @NonNull String component, String triggerId, String triggerType, String triggerFqn, String actionId, String actionType, String actionFqn, @NonNull ZonedDateTime identifiedAt) {
        if (reactionId == null) {
            throw new NullPointerException("reactionId is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (identifiedAt == null) {
            throw new NullPointerException("identifiedAt is marked non-null but is null");
        }
        this.reactionId = reactionId;
        this.component = component;
        this.identifiedAt = identifiedAt;
        this.triggerId = triggerId;
        this.triggerType = triggerType;
        this.triggerFqn = triggerFqn;
        this.actionId = actionId;
        this.actionType = actionType;
        this.actionFqn = actionFqn;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactionEntity that = (ReactionEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    public static ReactionEntityBuilder builder() {
        return new ReactionEntityBuilder();
    }

    @Generated
    protected ReactionEntity() {
    }

    @Generated
    public String toString() {
        return "ReactionEntity(id=" + this.getId() + ", reactionId=" + this.getReactionId() + ", component=" + this.getComponent() + ", triggerId=" + this.getTriggerId() + ", triggerType=" + this.getTriggerType() + ", triggerFqn=" + this.getTriggerFqn() + ", actionId=" + this.getActionId() + ", actionType=" + this.getActionType() + ", actionFqn=" + this.getActionFqn() + ", identifiedAt=" + String.valueOf(this.getIdentifiedAt()) + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getReactionId() {
        return this.reactionId;
    }

    @Generated
    public String getComponent() {
        return this.component;
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Generated
    public String getTriggerType() {
        return this.triggerType;
    }

    @Generated
    public String getTriggerFqn() {
        return this.triggerFqn;
    }

    @Generated
    public String getActionId() {
        return this.actionId;
    }

    @Generated
    public String getActionType() {
        return this.actionType;
    }

    @Generated
    public String getActionFqn() {
        return this.actionFqn;
    }

    @Generated
    public ZonedDateTime getIdentifiedAt() {
        return this.identifiedAt;
    }

    @Generated
    public static class ReactionEntityBuilder {
        @Generated
        private String reactionId;
        @Generated
        private String component;
        @Generated
        private String triggerId;
        @Generated
        private String triggerType;
        @Generated
        private String triggerFqn;
        @Generated
        private String actionId;
        @Generated
        private String actionType;
        @Generated
        private String actionFqn;
        @Generated
        private ZonedDateTime identifiedAt;

        @Generated
        ReactionEntityBuilder() {
        }

        @Generated
        public ReactionEntityBuilder reactionId(@NonNull String reactionId) {
            if (reactionId == null) {
                throw new NullPointerException("reactionId is marked non-null but is null");
            }
            this.reactionId = reactionId;
            return this;
        }

        @Generated
        public ReactionEntityBuilder component(@NonNull String component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
            return this;
        }

        @Generated
        public ReactionEntityBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        @Generated
        public ReactionEntityBuilder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Generated
        public ReactionEntityBuilder triggerFqn(String triggerFqn) {
            this.triggerFqn = triggerFqn;
            return this;
        }

        @Generated
        public ReactionEntityBuilder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        @Generated
        public ReactionEntityBuilder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Generated
        public ReactionEntityBuilder actionFqn(String actionFqn) {
            this.actionFqn = actionFqn;
            return this;
        }

        @Generated
        public ReactionEntityBuilder identifiedAt(@NonNull ZonedDateTime identifiedAt) {
            if (identifiedAt == null) {
                throw new NullPointerException("identifiedAt is marked non-null but is null");
            }
            this.identifiedAt = identifiedAt;
            return this;
        }

        @Generated
        public ReactionEntity build() {
            return new ReactionEntity(this.reactionId, this.component, this.triggerId, this.triggerType, this.triggerFqn, this.actionId, this.actionType, this.actionFqn, this.identifiedAt);
        }

        @Generated
        public String toString() {
            return "ReactionEntity.ReactionEntityBuilder(reactionId=" + this.reactionId + ", component=" + this.component + ", triggerId=" + this.triggerId + ", triggerType=" + this.triggerType + ", triggerFqn=" + this.triggerFqn + ", actionId=" + this.actionId + ", actionType=" + this.actionType + ", actionFqn=" + this.actionFqn + ", identifiedAt=" + String.valueOf(this.identifiedAt) + ")";
        }
    }
}

