/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(name="observation_property")
class ObservationProperty {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="observation_property_sequence")
    @SequenceGenerator(name="observation_property_sequence", sequenceName="observation_property_sequence", allocationSize=10)
    @Column(name="id")
    private Long id;
    @Column(name="reaction_trigger_fk")
    private Long reactionTriggerFk;
    @Column(name="reaction_action_fk")
    private Long reactionActionFk;
    @Column(name="property_key")
    private String key;
    @Column(name="property_value")
    private String value;

    private ObservationProperty(Long reactionTriggerFk, Long reactionActionFk, @NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.reactionTriggerFk = reactionTriggerFk;
        this.reactionActionFk = reactionActionFk;
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObservationProperty that = (ObservationProperty)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    public static ObservationPropertyBuilder builder() {
        return new ObservationPropertyBuilder();
    }

    @Generated
    protected ObservationProperty() {
    }

    @Generated
    public String toString() {
        return "ObservationProperty(id=" + this.getId() + ", reactionTriggerFk=" + this.getReactionTriggerFk() + ", reactionActionFk=" + this.getReactionActionFk() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getReactionTriggerFk() {
        return this.reactionTriggerFk;
    }

    @Generated
    public Long getReactionActionFk() {
        return this.reactionActionFk;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public static class ObservationPropertyBuilder {
        @Generated
        private Long reactionTriggerFk;
        @Generated
        private Long reactionActionFk;
        @Generated
        private String key;
        @Generated
        private String value;

        @Generated
        ObservationPropertyBuilder() {
        }

        @Generated
        public ObservationPropertyBuilder reactionTriggerFk(Long reactionTriggerFk) {
            this.reactionTriggerFk = reactionTriggerFk;
            return this;
        }

        @Generated
        public ObservationPropertyBuilder reactionActionFk(Long reactionActionFk) {
            this.reactionActionFk = reactionActionFk;
            return this;
        }

        @Generated
        public ObservationPropertyBuilder key(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        @Generated
        public ObservationPropertyBuilder value(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public ObservationProperty build() {
            return new ObservationProperty(this.reactionTriggerFk, this.reactionActionFk, this.key, this.value);
        }

        @Generated
        public String toString() {
            return "ObservationProperty.ObservationPropertyBuilder(reactionTriggerFk=" + this.reactionTriggerFk + ", reactionActionFk=" + this.reactionActionFk + ", key=" + this.key + ", value=" + this.value + ")";
        }
    }
}

