/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReaction;
import ch.admin.bit.jeap.reaction.observer.domain.Reaction;
import ch.admin.bit.jeap.reaction.observer.domain.Timeframe;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.Generated;

@Entity
@Table(name="observed_reaction")
class ObservedReactionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="observed_reaction_sequence")
    @SequenceGenerator(name="observed_reaction_sequence", sequenceName="observed_reaction_sequence", allocationSize=10)
    @Column(name="id")
    private Long id;
    @Column(name="reaction_fk")
    private Long reactionFk;
    @Column(name="idempotence_id")
    private String idempotenceId;
    @Column(name="timeframe_start")
    private ZonedDateTime timeframeStart;
    @Column(name="timeframe_end")
    private ZonedDateTime timeframeEnd;
    @Column(name="observation_date")
    private LocalDate observationDate;
    @Column(name="count")
    private int count;

    private ObservedReactionEntity(Long reactionFk, String idempotenceId, ZonedDateTime timeframeStart, ZonedDateTime timeframeEnd, LocalDate observationDate, int count) {
        this.reactionFk = reactionFk;
        this.idempotenceId = idempotenceId;
        this.timeframeStart = timeframeStart;
        this.timeframeEnd = timeframeEnd;
        this.observationDate = observationDate;
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObservedReactionEntity that = (ObservedReactionEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public ObservedReaction toDomainObject(Reaction reaction) {
        Timeframe timeframe = new Timeframe(this.timeframeStart, this.timeframeEnd);
        return new ObservedReaction(reaction.component(), reaction.reactionId(), timeframe, this.count);
    }

    @Generated
    public static ObservedReactionEntityBuilder builder() {
        return new ObservedReactionEntityBuilder();
    }

    @Generated
    protected ObservedReactionEntity() {
    }

    @Generated
    public String toString() {
        return "ObservedReactionEntity(id=" + this.getId() + ", reactionFk=" + this.getReactionFk() + ", idempotenceId=" + this.getIdempotenceId() + ", timeframeStart=" + String.valueOf(this.getTimeframeStart()) + ", timeframeEnd=" + String.valueOf(this.getTimeframeEnd()) + ", observationDate=" + String.valueOf(this.getObservationDate()) + ", count=" + this.getCount() + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getReactionFk() {
        return this.reactionFk;
    }

    @Generated
    public String getIdempotenceId() {
        return this.idempotenceId;
    }

    @Generated
    public ZonedDateTime getTimeframeStart() {
        return this.timeframeStart;
    }

    @Generated
    public ZonedDateTime getTimeframeEnd() {
        return this.timeframeEnd;
    }

    @Generated
    public LocalDate getObservationDate() {
        return this.observationDate;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public static class ObservedReactionEntityBuilder {
        @Generated
        private Long reactionFk;
        @Generated
        private String idempotenceId;
        @Generated
        private ZonedDateTime timeframeStart;
        @Generated
        private ZonedDateTime timeframeEnd;
        @Generated
        private LocalDate observationDate;
        @Generated
        private int count;

        @Generated
        ObservedReactionEntityBuilder() {
        }

        @Generated
        public ObservedReactionEntityBuilder reactionFk(Long reactionFk) {
            this.reactionFk = reactionFk;
            return this;
        }

        @Generated
        public ObservedReactionEntityBuilder idempotenceId(String idempotenceId) {
            this.idempotenceId = idempotenceId;
            return this;
        }

        @Generated
        public ObservedReactionEntityBuilder timeframeStart(ZonedDateTime timeframeStart) {
            this.timeframeStart = timeframeStart;
            return this;
        }

        @Generated
        public ObservedReactionEntityBuilder timeframeEnd(ZonedDateTime timeframeEnd) {
            this.timeframeEnd = timeframeEnd;
            return this;
        }

        @Generated
        public ObservedReactionEntityBuilder observationDate(LocalDate observationDate) {
            this.observationDate = observationDate;
            return this;
        }

        @Generated
        public ObservedReactionEntityBuilder count(int count) {
            this.count = count;
            return this;
        }

        @Generated
        public ObservedReactionEntity build() {
            return new ObservedReactionEntity(this.reactionFk, this.idempotenceId, this.timeframeStart, this.timeframeEnd, this.observationDate, this.count);
        }

        @Generated
        public String toString() {
            return "ObservedReactionEntity.ObservedReactionEntityBuilder(reactionFk=" + this.reactionFk + ", idempotenceId=" + this.idempotenceId + ", timeframeStart=" + String.valueOf(this.timeframeStart) + ", timeframeEnd=" + String.valueOf(this.timeframeEnd) + ", observationDate=" + String.valueOf(this.observationDate) + ", count=" + this.count + ")";
        }
    }
}

