/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.persistence.JpaObservationPropertiesRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaObservedReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.ObservedReactionRepositoryImpl;
import ch.admin.bit.jeap.reaction.observer.persistence.ObservedReactionsAggregatedRepositoryImpl;
import ch.admin.bit.jeap.reaction.observer.persistence.ReactionRepositoryImpl;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@AutoConfiguration
@EnableTransactionManagement
@EnableJpaRepositories
@EntityScan
class PersistenceAutoConfiguration {
    PersistenceAutoConfiguration() {
    }

    @Bean
    public LockProvider lockProvider(DataSource dataSource) {
        return new JdbcTemplateLockProvider(dataSource);
    }

    @Bean
    ReactionRepositoryImpl identifiedReactionRepository(JpaReactionRepository jpaReactionRepository, JpaObservationPropertiesRepository propertiesRepository) {
        return new ReactionRepositoryImpl(jpaReactionRepository, propertiesRepository);
    }

    @Bean
    ObservedReactionRepositoryImpl observedReactionRepository(JpaObservedReactionRepository jpaObservedReactionRepository, JpaReactionRepository jpaReactionRepository) {
        return new ObservedReactionRepositoryImpl(jpaObservedReactionRepository, jpaReactionRepository);
    }

    @Bean
    ObservedReactionsAggregatedRepositoryImpl observedReactionsAggregatedRepository(JdbcTemplate jdbcTemplate) {
        return new ObservedReactionsAggregatedRepositoryImpl(jdbcTemplate);
    }
}

