/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.domain.Observation;
import ch.admin.bit.jeap.reaction.observer.domain.Reaction;
import ch.admin.bit.jeap.reaction.observer.domain.ReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.ActionEntity;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaObservationPropertiesRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.ObservationProperty;
import ch.admin.bit.jeap.reaction.observer.persistence.ReactionEntity;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;

class ReactionRepositoryImpl
implements ReactionRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionRepositoryImpl.class);
    private final JpaReactionRepository jpaReactionRepository;
    private final JpaObservationPropertiesRepository jpaObservationPropertiesRepository;

    @Transactional
    public void save(Reaction reaction) {
        if (this.jpaReactionRepository.existsByComponentAndReactionId(reaction.component(), reaction.reactionId())) {
            return;
        }
        try {
            Observation trigger = reaction.trigger();
            ReactionEntity.ReactionEntityBuilder builder = ReactionEntity.builder().system(reaction.system()).component(reaction.component()).reactionId(reaction.reactionId()).identifiedAt(reaction.identifiedAt());
            if (trigger != null) {
                builder.triggerId(reaction.trigger().id());
                builder.triggerType(trigger.type());
                builder.triggerFqn(trigger.fqn());
            }
            ReactionEntity reactionEntity = builder.build();
            for (Observation action2 : reaction.actions()) {
                ActionEntity actionEntity = ActionEntity.builder().reaction(reactionEntity).actionId(action2.id()).actionType(action2.type()).actionFqn(action2.fqn()).build();
                reactionEntity.addAction(actionEntity);
            }
            Long reactionId = ((ReactionEntity)this.jpaReactionRepository.save(reactionEntity)).getId();
            this.saveProps(reactionId, trigger, true);
            for (ActionEntity actionEntity : reactionEntity.getActions()) {
                reaction.actions().stream().filter(action -> action.id().equals(actionEntity.getActionId())).findFirst().ifPresent(action -> this.saveProps(actionEntity.getId(), (Observation)action, false));
            }
        }
        catch (DuplicateKeyException ex) {
            log.debug("Identified reaction already exists, ignoring", (Throwable)ex);
        }
    }

    private void saveProps(Long reactionId, Observation observation, boolean isTrigger) {
        if (observation == null || observation.props() == null || observation.props().isEmpty()) {
            return;
        }
        observation.props().forEach((key, value) -> {
            ObservationProperty.ObservationPropertyBuilder builder = ObservationProperty.builder().key((String)key).value((String)value);
            if (isTrigger) {
                builder.reactionTriggerFk(reactionId);
            } else {
                builder.actionFk(reactionId);
            }
            this.jpaObservationPropertiesRepository.save(builder.build());
        });
    }

    @Transactional
    public Optional<Reaction> findByComponentAndReactionId(String component, String reactionId) {
        return this.jpaReactionRepository.findByComponentAndReactionId(component, reactionId).map(entity -> {
            List actions = entity.getActions().stream().map(actionEntity -> new Observation(actionEntity.getActionId(), actionEntity.getActionType(), actionEntity.getActionFqn(), this.loadProps(actionEntity.getId(), false))).collect(Collectors.toList());
            return new Reaction(entity.getSystem(), entity.getComponent(), entity.getReactionId(), this.observation(entity.getTriggerId(), entity.getTriggerType(), entity.getTriggerFqn(), this.loadProps(entity.getId(), true)), actions, entity.getIdentifiedAt());
        });
    }

    private Map<String, String> loadProps(Long reactionId, boolean isTrigger) {
        if (isTrigger) {
            return this.jpaObservationPropertiesRepository.findByReactionTriggerFk(reactionId).collect(Collectors.toMap(ObservationProperty::getKey, ObservationProperty::getValue));
        }
        return this.jpaObservationPropertiesRepository.findByActionFk(reactionId).collect(Collectors.toMap(ObservationProperty::getKey, ObservationProperty::getValue));
    }

    private Observation observation(String id, String type, String fqn, Map<String, String> props) {
        if (type == null) {
            return null;
        }
        return new Observation(id, type, fqn, props);
    }

    private String getTriggerId(String reactionId) {
        String triggerIdFragment = reactionId.split("#")[0];
        return triggerIdFragment.isBlank() ? null : triggerIdFragment;
    }

    private String getActionId(String reactionId) {
        String[] parts = reactionId.split("#");
        if (parts.length > 1) {
            return parts[1];
        }
        return null;
    }

    @Generated
    public ReactionRepositoryImpl(JpaReactionRepository jpaReactionRepository, JpaObservationPropertiesRepository jpaObservationPropertiesRepository) {
        this.jpaReactionRepository = jpaReactionRepository;
        this.jpaObservationPropertiesRepository = jpaObservationPropertiesRepository;
    }
}

