/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.persistence.InterfaceEntity;
import ch.admin.bit.jeap.reaction.observer.persistence.ReactionEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Objects;
import lombok.Generated;

@Entity
@Table(name="action")
public class ActionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="action_sequence")
    @SequenceGenerator(name="action_sequence", sequenceName="action_sequence", allocationSize=10)
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="reaction_id")
    private ReactionEntity reaction;
    @Column(name="action_id")
    private String actionId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="interface_id")
    private InterfaceEntity actionInterface;

    public ActionEntity(ReactionEntity reaction, String actionId, InterfaceEntity actionInterface) {
        this.reaction = reaction;
        this.actionId = actionId;
        this.actionInterface = actionInterface;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionEntity that = (ActionEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    public static ActionEntityBuilder builder() {
        return new ActionEntityBuilder();
    }

    @Generated
    protected ActionEntity() {
    }

    @Generated
    public String toString() {
        return "ActionEntity(id=" + this.getId() + ", actionId=" + this.getActionId() + ", actionInterface=" + String.valueOf(this.getActionInterface()) + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public ReactionEntity getReaction() {
        return this.reaction;
    }

    @Generated
    public String getActionId() {
        return this.actionId;
    }

    @Generated
    public InterfaceEntity getActionInterface() {
        return this.actionInterface;
    }

    @Generated
    public void setReaction(ReactionEntity reaction) {
        this.reaction = reaction;
    }

    @Generated
    public static class ActionEntityBuilder {
        @Generated
        private ReactionEntity reaction;
        @Generated
        private String actionId;
        @Generated
        private InterfaceEntity actionInterface;

        @Generated
        ActionEntityBuilder() {
        }

        @Generated
        public ActionEntityBuilder reaction(ReactionEntity reaction) {
            this.reaction = reaction;
            return this;
        }

        @Generated
        public ActionEntityBuilder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        @Generated
        public ActionEntityBuilder actionInterface(InterfaceEntity actionInterface) {
            this.actionInterface = actionInterface;
            return this;
        }

        @Generated
        public ActionEntity build() {
            return new ActionEntity(this.reaction, this.actionId, this.actionInterface);
        }

        @Generated
        public String toString() {
            return "ActionEntity.ActionEntityBuilder(reaction=" + String.valueOf(this.reaction) + ", actionId=" + this.actionId + ", actionInterface=" + String.valueOf(this.actionInterface) + ")";
        }
    }
}

