/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.domain.ReactionGraphRepository;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Action;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Interface;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Message;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Reaction;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.SemanticType;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Trigger;
import ch.admin.bit.jeap.reaction.observer.persistence.ActionEntity;
import ch.admin.bit.jeap.reaction.observer.persistence.InterfaceEntity;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.ReactionEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ReactionGraphRepositoryImpl
implements ReactionGraphRepository {
    private final JpaReactionRepository jpaReactionRepository;

    public ReactionGraphRepositoryImpl(JpaReactionRepository jpaReactionRepository) {
        this.jpaReactionRepository = jpaReactionRepository;
    }

    public Graph buildFullGraph() {
        List<ReactionEntity> entities = this.jpaReactionRepository.findAllWithActions();
        ArrayList<Object> nodes = new ArrayList<Object>();
        ArrayList<Object> edges = new ArrayList<Object>();
        HashMap<Long, Interface> interfaces = new HashMap<Long, Interface>();
        for (ReactionEntity entity : entities) {
            Reaction reaction = Reaction.builder().id(entity.getId().longValue()).component(entity.getComponent()).system(entity.getSystem()).build();
            nodes.add(reaction);
            InterfaceEntity triggerInterface = entity.getTriggerInterface();
            if (triggerInterface != null) {
                Message triggerMessage = (Message)interfaces.computeIfAbsent(triggerInterface.getId(), id -> this.createMessage(triggerInterface));
                edges.add(Trigger.builder().source((Interface)triggerMessage).target(reaction).build());
            }
            for (ActionEntity actionEntity : entity.getActions()) {
                InterfaceEntity actionInterface = actionEntity.getActionInterface();
                Message actionMessage = (Message)interfaces.computeIfAbsent(actionInterface.getId(), id -> this.createMessage(actionInterface));
                edges.add(Action.builder().source(reaction).target((Interface)actionMessage).build());
            }
        }
        nodes.addAll(interfaces.values());
        return new Graph(nodes, edges);
    }

    private Message createMessage(InterfaceEntity iface) {
        String[] stringArray;
        if (iface.getFqn().contains("/")) {
            stringArray = iface.getFqn().split("/");
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = iface.getFqn();
            stringArray = stringArray2;
            stringArray2[1] = null;
        }
        String[] fqnParts = stringArray;
        return Message.builder().id(iface.getId().longValue()).messageType(fqnParts[0]).variant(fqnParts.length > 1 ? fqnParts[1] : null).semantic(SemanticType.fromValue((String)iface.getType())).build();
    }
}

