/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionRepository;
import ch.admin.bit.jeap.reaction.observer.domain.models.ObservedReaction;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaObservedReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.ObservedReactionEntity;
import java.time.ZonedDateTime;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

class ObservedReactionRepositoryImpl
implements ObservedReactionRepository {
    private final JpaObservedReactionRepository jpaObservedReactionRepository;
    private final JpaReactionRepository jpaReactionRepository;

    ObservedReactionRepositoryImpl(JpaObservedReactionRepository jpaObservedReactionRepository, JpaReactionRepository jpaReactionRepository) {
        this.jpaObservedReactionRepository = jpaObservedReactionRepository;
        this.jpaReactionRepository = jpaReactionRepository;
    }

    @Transactional
    public void saveAll(String idempotenceId, List<ObservedReaction> observedReactions) {
        List<ObservedReactionEntity> entities = observedReactions.stream().map(observedReaction -> this.toEntity(idempotenceId, (ObservedReaction)observedReaction)).toList();
        if (!this.jpaObservedReactionRepository.existsByIdempotenceId(idempotenceId)) {
            this.jpaObservedReactionRepository.saveAll(entities);
        }
    }

    public void deleteByTimeframeStartBefore(ZonedDateTime startOfDay) {
        this.jpaObservedReactionRepository.deleteByTimeframeStartBefore(startOfDay);
    }

    private ObservedReactionEntity toEntity(String idempotenceId, ObservedReaction observedReaction) {
        ZonedDateTime start = observedReaction.timeframe().start();
        return ObservedReactionEntity.builder().reactionFk(this.reactionFk(observedReaction.component(), observedReaction.reactionId())).idempotenceId(idempotenceId).timeframeStart(start).timeframeEnd(observedReaction.timeframe().end()).observationDate(start.toLocalDate()).count(observedReaction.count()).build();
    }

    private Long reactionFk(String component, String reactionId) {
        return this.jpaReactionRepository.findIdByComponentAndReactionId(component, reactionId).orElseThrow(() -> new IllegalStateException("Reaction not found: component=" + component + ", reactionId=" + reactionId));
    }
}

