/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionsAggregatedRepository;
import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionsAggregatedStatistics;
import ch.admin.bit.jeap.reaction.observer.domain.models.Action;
import jakarta.transaction.Transactional;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
class ObservedReactionsAggregatedRepositoryImpl
implements ObservedReactionsAggregatedRepository {
    private final JdbcTemplate jdbcTemplate;

    @Transactional
    public void aggregateObservedReactionsForDay(LocalDate date) {
        this.jdbcTemplate.update("INSERT INTO observed_reactions_aggregated (reaction_fk, component, date, count)\nSELECT obsreaction.reaction_fk, r.component, obsreaction.observation_date, sum(obsreaction.count)\nFROM observed_reaction obsreaction\nINNER JOIN reaction r on obsreaction.reaction_fk= r.id\n       WHERE obsreaction.observation_date = ?\n       GROUP BY obsreaction.reaction_fk, obsreaction.observation_date, r.component\n", new Object[]{date});
    }

    public List<ObservedReactionsAggregatedStatistics> getStatistics(String component, LocalDate fromDate) {
        String sql = "WITH base_stats AS (\n    SELECT\n        ora.component,\n        i_trigger.type AS trigger_type,\n        i_trigger.fqn AS trigger_fqn,\n        ora.reaction_fk,\n        SUM(ora.count) AS count,\n        CAST(PERCENTILE_CONT(0.5) WITHIN GROUP (ORDER BY ora.count) AS FLOAT) AS median,\n        CASE WHEN r.trigger_id IS NULL\n            THEN NULL\n        ELSE\n            CAST((TRUNC(SUM(ora.count) * 100.0 / NULLIF(SUM(SUM(ora.count)) OVER (PARTITION BY r.trigger_id), 0), 2)) AS FLOAT)\n        END AS percentage\n    FROM observed_reactions_aggregated ora\n    INNER JOIN reaction r ON r.id = ora.reaction_fk\n    LEFT JOIN interface i_trigger ON r.interface_id = i_trigger.id\n    WHERE ora.component = ? AND ora.date >= ?\n    GROUP BY ora.component, ora.reaction_fk, r.trigger_id, i_trigger.type, i_trigger.fqn\n)\nSELECT\n    bs.component,\n    bs.trigger_type,\n    bs.trigger_fqn,\n    i_action.type AS action_type,\n    i_action.fqn AS action_fqn,\n    bs.count,\n    bs.median,\n    bs.percentage,\n    bs.reaction_fk,\n    act.id AS action_id,\n    STRING_AGG(opt.property_key || '=' || opt.property_value, ',') AS trigger_properties,\n    STRING_AGG(prop.property_key || '=' || prop.property_value, ',') AS action_properties\nFROM base_stats bs\nLEFT JOIN observation_property opt ON bs.reaction_fk = opt.reaction_trigger_fk\nLEFT JOIN action act ON bs.reaction_fk = act.reaction_id\nLEFT JOIN interface i_action ON act.interface_id = i_action.id\nLEFT JOIN observation_property prop ON prop.action_fk = act.id\nGROUP BY bs.component, bs.trigger_type, bs.trigger_fqn, i_action.type, i_action.fqn, bs.count, bs.median, bs.percentage, bs.reaction_fk, act.id\nORDER BY bs.reaction_fk DESC\n";
        Collection query = (Collection)this.jdbcTemplate.query(sql, rs -> {
            LinkedHashMap<Long, ObservedReactionsAggregatedStatistics> statisticsMap = new LinkedHashMap<Long, ObservedReactionsAggregatedStatistics>();
            while (rs.next()) {
                Long reactionFk = rs.getLong("reaction_fk");
                ObservedReactionsAggregatedStatistics statistics = statisticsMap.computeIfAbsent(reactionFk, k -> {
                    try {
                        String triggerType = rs.getString("trigger_type");
                        Double percentage = rs.getDouble("percentage");
                        if (rs.wasNull() || triggerType == null) {
                            percentage = null;
                        }
                        return new ObservedReactionsAggregatedStatistics(rs.getString("component"), triggerType, rs.getString("trigger_fqn"), new ArrayList(), rs.getLong("count"), rs.getDouble("median"), percentage, this.parseAsMap(rs.getString("trigger_properties")));
                    }
                    catch (SQLException e) {
                        throw new DataAccessException("Error processing result set", e){};
                    }
                });
                rs.getLong("action_id");
                if (rs.wasNull()) continue;
                String actionType = rs.getString("action_type");
                String actionFqn = rs.getString("action_fqn");
                Map<String, String> actionProperties = this.parseAsMap(rs.getString("action_properties"));
                statistics.actions().add(new Action(actionType, actionFqn, actionProperties));
            }
            return statisticsMap.values();
        }, new Object[]{component, fromDate});
        return new ArrayList<ObservedReactionsAggregatedStatistics>(query == null ? Collections.emptyList() : query);
    }

    private Map<String, String> parseAsMap(String propsString) {
        if (propsString == null || propsString.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> triggerProperties = new HashMap<String, String>();
        for (String prop : propsString.split(",")) {
            String[] keyValue = prop.split("=", 2);
            if (keyValue.length != 2) continue;
            triggerProperties.put(keyValue[0], keyValue[1]);
        }
        return triggerProperties;
    }

    @Transactional
    public void deleteAggregatedDataOlderThan(LocalDate date) {
        this.jdbcTemplate.update("DELETE FROM observed_reactions_aggregated WHERE date < ?", new Object[]{date});
    }

    public Map<Long, Integer> getMedianPerReaction(LocalDate fromDate) {
        String sql = "SELECT reaction_fk,\n       CAST(PERCENTILE_CONT(0.5) WITHIN GROUP (ORDER BY count) AS INTEGER) AS median\nFROM observed_reactions_aggregated\nWHERE date >= ?\nGROUP BY reaction_fk\n";
        return (Map)this.jdbcTemplate.query(sql, rs -> {
            HashMap<Long, Integer> result = new HashMap<Long, Integer>();
            while (rs.next()) {
                result.put(rs.getLong("reaction_fk"), rs.getInt("median"));
            }
            return result;
        }, new Object[]{fromDate});
    }

    @Generated
    public ObservedReactionsAggregatedRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

