/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.persistence.ActionEntity;
import ch.admin.bit.jeap.reaction.observer.persistence.InterfaceEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@NamedEntityGraph(name="Reaction.withActions", attributeNodes={@NamedAttributeNode(value="actions")})
@Entity
@Table(name="reaction")
class ReactionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="reaction_sequence")
    @SequenceGenerator(name="reaction_sequence", sequenceName="reaction_sequence", allocationSize=10)
    @Column(name="id")
    private Long id;
    @Column(name="reaction_id")
    private String reactionId;
    @Column(name="system")
    private String system;
    @Column(name="component")
    private String component;
    @Column(name="trigger_id")
    private String triggerId;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="interface_id")
    private InterfaceEntity triggerInterface;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="reaction")
    private List<ActionEntity> actions = new ArrayList<ActionEntity>();
    @Column(name="identified_at")
    private ZonedDateTime identifiedAt;

    private ReactionEntity(@NonNull String reactionId, String system, @NonNull String component, String triggerId, InterfaceEntity triggerInterface, @NonNull ZonedDateTime identifiedAt) {
        if (reactionId == null) {
            throw new NullPointerException("reactionId is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (identifiedAt == null) {
            throw new NullPointerException("identifiedAt is marked non-null but is null");
        }
        this.reactionId = reactionId;
        this.system = system;
        this.component = component;
        this.identifiedAt = identifiedAt;
        this.triggerId = triggerId;
        this.triggerInterface = triggerInterface;
    }

    public void addAction(ActionEntity action) {
        if (this.actions == null) {
            this.actions = new ArrayList<ActionEntity>();
        }
        action.setReaction(this);
        this.actions.add(action);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactionEntity that = (ReactionEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Generated
    public static ReactionEntityBuilder builder() {
        return new ReactionEntityBuilder();
    }

    @Generated
    protected ReactionEntity() {
    }

    @Generated
    public String toString() {
        return "ReactionEntity(id=" + this.getId() + ", reactionId=" + this.getReactionId() + ", system=" + this.getSystem() + ", component=" + this.getComponent() + ", triggerId=" + this.getTriggerId() + ", triggerInterface=" + String.valueOf(this.getTriggerInterface()) + ", actions=" + String.valueOf(this.getActions()) + ", identifiedAt=" + String.valueOf(this.getIdentifiedAt()) + ")";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getReactionId() {
        return this.reactionId;
    }

    @Generated
    public String getSystem() {
        return this.system;
    }

    @Generated
    public String getComponent() {
        return this.component;
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Generated
    public InterfaceEntity getTriggerInterface() {
        return this.triggerInterface;
    }

    @Generated
    public List<ActionEntity> getActions() {
        return this.actions;
    }

    @Generated
    public ZonedDateTime getIdentifiedAt() {
        return this.identifiedAt;
    }

    @Generated
    public static class ReactionEntityBuilder {
        @Generated
        private String reactionId;
        @Generated
        private String system;
        @Generated
        private String component;
        @Generated
        private String triggerId;
        @Generated
        private InterfaceEntity triggerInterface;
        @Generated
        private ZonedDateTime identifiedAt;

        @Generated
        ReactionEntityBuilder() {
        }

        @Generated
        public ReactionEntityBuilder reactionId(@NonNull String reactionId) {
            if (reactionId == null) {
                throw new NullPointerException("reactionId is marked non-null but is null");
            }
            this.reactionId = reactionId;
            return this;
        }

        @Generated
        public ReactionEntityBuilder system(String system) {
            this.system = system;
            return this;
        }

        @Generated
        public ReactionEntityBuilder component(@NonNull String component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
            return this;
        }

        @Generated
        public ReactionEntityBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        @Generated
        public ReactionEntityBuilder triggerInterface(InterfaceEntity triggerInterface) {
            this.triggerInterface = triggerInterface;
            return this;
        }

        @Generated
        public ReactionEntityBuilder identifiedAt(@NonNull ZonedDateTime identifiedAt) {
            if (identifiedAt == null) {
                throw new NullPointerException("identifiedAt is marked non-null but is null");
            }
            this.identifiedAt = identifiedAt;
            return this;
        }

        @Generated
        public ReactionEntity build() {
            return new ReactionEntity(this.reactionId, this.system, this.component, this.triggerId, this.triggerInterface, this.identifiedAt);
        }

        @Generated
        public String toString() {
            return "ReactionEntity.ReactionEntityBuilder(reactionId=" + this.reactionId + ", system=" + this.system + ", component=" + this.component + ", triggerId=" + this.triggerId + ", triggerInterface=" + String.valueOf(this.triggerInterface) + ", identifiedAt=" + String.valueOf(this.identifiedAt) + ")";
        }
    }
}

