/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.domain.ReactionRepository;
import ch.admin.bit.jeap.reaction.observer.domain.models.Observation;
import ch.admin.bit.jeap.reaction.observer.domain.models.Reaction;
import ch.admin.bit.jeap.reaction.observer.persistence.ActionEntity;
import ch.admin.bit.jeap.reaction.observer.persistence.InterfaceEntity;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaInterfaceRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaObservationPropertiesRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.JpaReactionRepository;
import ch.admin.bit.jeap.reaction.observer.persistence.ObservationProperty;
import ch.admin.bit.jeap.reaction.observer.persistence.ReactionEntity;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;

class ReactionRepositoryImpl
implements ReactionRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionRepositoryImpl.class);
    private final JpaReactionRepository jpaReactionRepository;
    private final JpaObservationPropertiesRepository jpaObservationPropertiesRepository;
    private final JpaInterfaceRepository jpaInterfaceRepository;

    @Transactional
    public void save(Reaction reaction) {
        if (this.jpaReactionRepository.existsByComponentAndReactionId(reaction.component(), reaction.reactionId())) {
            return;
        }
        try {
            Observation trigger = reaction.trigger();
            ReactionEntity.ReactionEntityBuilder builder = ReactionEntity.builder().system(reaction.system()).component(reaction.component()).reactionId(reaction.reactionId()).identifiedAt(reaction.identifiedAt());
            if (trigger != null && trigger.id() != null && trigger.type() != null && trigger.fqn() != null) {
                builder.triggerId(trigger.id());
                builder.triggerInterface(this.resolveInterface(trigger.type(), trigger.fqn()));
            }
            ReactionEntity reactionEntity = builder.build();
            for (Observation action2 : reaction.actions()) {
                ActionEntity actionEntity = ActionEntity.builder().reaction(reactionEntity).actionId(action2.id()).actionInterface(this.resolveInterface(action2.type(), action2.fqn())).build();
                reactionEntity.addAction(actionEntity);
            }
            Long reactionId = ((ReactionEntity)this.jpaReactionRepository.save(reactionEntity)).getId();
            this.saveProps(reactionId, trigger, true);
            for (ActionEntity actionEntity : reactionEntity.getActions()) {
                reaction.actions().stream().filter(action -> action.id().equals(actionEntity.getActionId())).findFirst().ifPresent(action -> this.saveProps(actionEntity.getId(), (Observation)action, false));
            }
        }
        catch (DuplicateKeyException ex) {
            log.debug("Identified reaction already exists, ignoring", (Throwable)ex);
        }
    }

    private void saveProps(Long reactionId, Observation observation, boolean isTrigger) {
        if (observation == null || observation.props() == null || observation.props().isEmpty()) {
            return;
        }
        observation.props().forEach((key, value) -> {
            ObservationProperty.ObservationPropertyBuilder builder = ObservationProperty.builder().key((String)key).value((String)value);
            if (isTrigger) {
                builder.reactionTriggerFk(reactionId);
            } else {
                builder.actionFk(reactionId);
            }
            this.jpaObservationPropertiesRepository.save(builder.build());
        });
    }

    @Transactional
    public Optional<Reaction> findByComponentAndReactionId(String component, String reactionId) {
        return this.jpaReactionRepository.findByComponentAndReactionId(component, reactionId).map(entity -> {
            List actions = entity.getActions().stream().map(actionEntity -> new Observation(actionEntity.getActionId(), actionEntity.getActionInterface().getType(), actionEntity.getActionInterface().getFqn(), this.loadProps(actionEntity.getId(), false))).collect(Collectors.toList());
            Observation trigger = null;
            if (entity.getTriggerInterface() != null) {
                trigger = new Observation(entity.getTriggerId(), entity.getTriggerInterface().getType(), entity.getTriggerInterface().getFqn(), this.loadProps(entity.getId(), true));
            }
            return new Reaction(entity.getSystem(), entity.getComponent(), entity.getReactionId(), trigger, actions, entity.getIdentifiedAt());
        });
    }

    private Map<String, String> loadProps(Long reactionId, boolean isTrigger) {
        if (isTrigger) {
            return this.jpaObservationPropertiesRepository.findByReactionTriggerFk(reactionId).collect(Collectors.toMap(ObservationProperty::getKey, ObservationProperty::getValue));
        }
        return this.jpaObservationPropertiesRepository.findByActionFk(reactionId).collect(Collectors.toMap(ObservationProperty::getKey, ObservationProperty::getValue));
    }

    private Observation observation(String id, String type, String fqn, Map<String, String> props) {
        if (type == null) {
            return null;
        }
        return new Observation(id, type, fqn, props);
    }

    private String getTriggerId(String reactionId) {
        String triggerIdFragment = reactionId.split("#")[0];
        return triggerIdFragment.isBlank() ? null : triggerIdFragment;
    }

    private String getActionId(String reactionId) {
        String[] parts = reactionId.split("#");
        if (parts.length > 1) {
            return parts[1];
        }
        return null;
    }

    private InterfaceEntity resolveInterface(String type, String fqn) {
        return this.jpaInterfaceRepository.findByTypeAndFqn(type, fqn).orElseGet(() -> {
            try {
                return (InterfaceEntity)this.jpaInterfaceRepository.save(new InterfaceEntity(type, fqn));
            }
            catch (DataIntegrityViolationException e) {
                return this.jpaInterfaceRepository.findByTypeAndFqn(type, fqn).orElseThrow(() -> e);
            }
        });
    }

    @Generated
    public ReactionRepositoryImpl(JpaReactionRepository jpaReactionRepository, JpaObservationPropertiesRepository jpaObservationPropertiesRepository, JpaInterfaceRepository jpaInterfaceRepository) {
        this.jpaReactionRepository = jpaReactionRepository;
        this.jpaObservationPropertiesRepository = jpaObservationPropertiesRepository;
        this.jpaInterfaceRepository = jpaInterfaceRepository;
    }
}

