/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.persistence;

import ch.admin.bit.jeap.reaction.observer.domain.Action;
import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionsAggregatedRepository;
import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionsAggregatedStatisticsV2;
import jakarta.transaction.Transactional;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
class ObservedReactionsAggregatedRepositoryImpl
implements ObservedReactionsAggregatedRepository {
    private final JdbcTemplate jdbcTemplate;

    @Transactional
    public void aggregateObservedReactionsForDay(LocalDate date) {
        this.jdbcTemplate.update("INSERT INTO observed_reactions_aggregated (reaction_fk, component, trigger_id, trigger_type, trigger_fqn, action_id, action_type, action_fqn, date, count)\nSELECT obsreaction.reaction_fk as rid, r.component, r.trigger_id, r.trigger_type, r.trigger_fqn, r.action_id, r.action_type, r.action_fqn, obsreaction.observation_date, sum(obsreaction.count)\nFROM observed_reaction obsreaction\nINNER JOIN reaction r on obsreaction.reaction_fk= r.id\n       WHERE obsreaction.observation_date = ?\n       GROUP BY obsreaction.reaction_fk, obsreaction.observation_date, r.component, r.trigger_id, r.trigger_type, r.trigger_fqn, r.action_id, r.action_type, r.action_fqn\n", new Object[]{date});
    }

    public List<ObservedReactionsAggregatedStatisticsV2> getStatistics(String component, LocalDate fromDate) {
        String sql = "WITH base_stats AS (\n    SELECT\n        ora.component,\n        ora.trigger_type,\n        ora.trigger_fqn,\n        ora.action_type as old_action_type,\n        ora.action_fqn as old_action_fqn,\n        ora.reaction_fk,\n        SUM(ora.count) AS count,\n        CAST(PERCENTILE_CONT(0.5) WITHIN GROUP (ORDER BY ora.count) AS FLOAT) AS median,\n        CASE WHEN ora.trigger_id IS NULL\n            THEN NULL\n        ELSE\n            CAST((TRUNC(SUM(ora.count) * 100.0 / NULLIF(SUM(SUM(ora.count)) OVER (PARTITION BY ora.trigger_id), 0), 2)) AS FLOAT)\n        END AS percentage\n    FROM observed_reactions_aggregated ora\n    WHERE ora.component = ? AND ora.date >= ?\n    GROUP BY ora.component, ora.reaction_fk, ora.trigger_id, ora.action_id, ora.trigger_type, ora.trigger_fqn, ora.action_type, ora.action_fqn\n)\nSELECT\n    bs.component,\n    bs.trigger_type,\n    bs.trigger_fqn,\n    act.action_type,\n    act.action_fqn,\n    bs.old_action_type,\n    bs.old_action_fqn,\n    bs.count,\n    bs.median,\n    bs.percentage,\n    bs.reaction_fk,\n    act.id as action_id,\n    STRING_AGG(opt.property_key || '=' || opt.property_value, ',') AS trigger_properties,\n    STRING_AGG(opa.property_key || '=' || opa.property_value, ',') AS old_action_properties,\n    STRING_AGG(prop.property_key || '=' || prop.property_value, ',') AS action_properties\nFROM base_stats bs\nLEFT JOIN observation_property opt ON bs.reaction_fk = opt.reaction_trigger_fk\nLEFT JOIN observation_property opa ON bs.reaction_fk = opa.reaction_action_fk\nLEFT JOIN action act ON bs.reaction_fk = act.reaction_id\nLEFT JOIN observation_property prop on prop.action_fk=act.id\nGROUP BY bs.component, bs.trigger_type, bs.trigger_fqn, bs.old_action_type, bs.old_action_fqn, act.action_type, act.action_fqn, bs.count, bs.median, bs.percentage, bs.reaction_fk, act.id\nORDER BY bs.reaction_fk DESC\n";
        Collection query = (Collection)this.jdbcTemplate.query(sql, rs -> {
            LinkedHashMap<Long, ObservedReactionsAggregatedStatisticsV2> statisticsMap = new LinkedHashMap<Long, ObservedReactionsAggregatedStatisticsV2>();
            while (rs.next()) {
                Map<String, String> actionProperties;
                Long reactionFk = rs.getLong("reaction_fk");
                ObservedReactionsAggregatedStatisticsV2 statistics = statisticsMap.computeIfAbsent(reactionFk, k -> {
                    try {
                        String triggerType = rs.getString("trigger_type");
                        Double percentage = rs.getDouble("percentage");
                        if (rs.wasNull() || triggerType == null) {
                            percentage = null;
                        }
                        return new ObservedReactionsAggregatedStatisticsV2(rs.getString("component"), triggerType, rs.getString("trigger_fqn"), new ArrayList(), rs.getLong("count"), rs.getDouble("median"), percentage, this.parseAsMap(rs.getString("trigger_properties")));
                    }
                    catch (SQLException e) {
                        throw new DataAccessException("Error processing result set", e){};
                    }
                });
                String actionType = rs.getString("old_action_type");
                String actionFqn = rs.getString("old_action_fqn");
                if (actionType != null && !actionType.isEmpty()) {
                    actionProperties = this.parseAsMap(rs.getString("old_action_properties"));
                    statistics.actions().add(new Action(actionType, actionFqn, actionProperties));
                    continue;
                }
                Long actionId = rs.getLong("action_id");
                if (rs.wasNull()) continue;
                actionType = rs.getString("action_type");
                actionFqn = rs.getString("action_fqn");
                actionProperties = this.parseAsMap(rs.getString("action_properties"));
                statistics.actions().add(new Action(actionType, actionFqn, actionProperties));
            }
            return statisticsMap.values();
        }, new Object[]{component, fromDate});
        return new ArrayList<ObservedReactionsAggregatedStatisticsV2>(query == null ? Collections.emptyList() : query);
    }

    private Map<String, String> parseAsMap(String propsString) {
        if (propsString == null || propsString.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> triggerProperties = new HashMap<String, String>();
        for (String prop : propsString.split(",")) {
            String[] keyValue = prop.split("=", 2);
            if (keyValue.length != 2) continue;
            triggerProperties.put(keyValue[0], keyValue[1]);
        }
        return triggerProperties;
    }

    public void deleteAggregatedDataOlderThan(LocalDate date) {
        this.jdbcTemplate.update("DELETE FROM observed_reactions_aggregated WHERE date < ?", new Object[]{date});
    }

    @Generated
    public ObservedReactionsAggregatedRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

