/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.service.test;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.reaction.observer.event.observed.Observation;
import ch.admin.bit.jeap.reaction.observer.event.observed.ReactionsObservedEvent;
import ch.admin.bit.jeap.reaction.observer.event.observed.ReactionsObservedPayload;
import ch.admin.bit.jeap.reaction.observer.event.observed.Timeframe;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ReactionsObservedEventBuilder
extends AvroDomainEventBuilder<ReactionsObservedEventBuilder, ReactionsObservedEvent> {
    private final String serviceName;
    private final String systemName;
    private UUID serviceInstanceIdentifier;
    private Timeframe timeframe;
    private List<Observation> observations;

    public ReactionsObservedEventBuilder(String serviceName, String systemName) {
        super(ReactionsObservedEvent::new);
        this.serviceName = serviceName;
        this.systemName = systemName;
    }

    public ReactionsObservedEventBuilder serviceInstanceIdentifier(UUID serviceInstanceIdentifier) {
        this.serviceInstanceIdentifier = serviceInstanceIdentifier;
        return this;
    }

    public ReactionsObservedEventBuilder timeframe(Instant from, Instant to) {
        this.timeframe = new Timeframe(from, to);
        return this;
    }

    public ReactionsObservedEventBuilder countByReactionId(Map<String, Integer> countByReactionId) {
        this.observations = this.toObservations(countByReactionId);
        return this;
    }

    private List<Observation> toObservations(Map<String, Integer> countByReactionId) {
        return countByReactionId.entrySet().stream().map(entry -> new Observation((String)entry.getKey(), (Integer)entry.getValue())).toList();
    }

    public ReactionsObservedEvent build() {
        this.setPayload((MessagePayload)new ReactionsObservedPayload(this.timeframe, this.observations));
        this.idempotenceId(this.createIdempotenceId());
        return (ReactionsObservedEvent)super.build();
    }

    private String createIdempotenceId() {
        return this.serviceName + "-" + String.valueOf(this.serviceInstanceIdentifier) + "-" + String.valueOf(this.timeframe.getStart()) + "-" + String.valueOf(this.timeframe.getEnd());
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected String getSystemName() {
        return this.systemName;
    }

    protected ReactionsObservedEventBuilder self() {
        return this;
    }
}

