/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.service.test.model;

import ch.admin.bit.jeap.reaction.observer.domain.Observation;
import ch.admin.bit.jeap.reaction.observer.domain.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.service.test.model.TestObservation;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public record TestReaction(TestObservation trigger, TestObservation action, String id) {
    public TestReaction(TestObservation trigger, TestObservation action) {
        this(trigger, action, TestReaction.createId(trigger, action));
    }

    private static String createId(TestObservation trigger, TestObservation action) {
        if (trigger == null) {
            return "#" + action.id();
        }
        if (action == null) {
            return trigger.id();
        }
        return trigger.id() + "#" + action.id();
    }

    public Reaction createExpectedReaction(ReactionIdentifiedEvent event) {
        Observation trigger = null;
        if (this.trigger() != null) {
            trigger = new Observation(this.trigger().type(), this.trigger().fqn(), this.trigger().props());
        }
        Observation action = null;
        if (this.action() != null) {
            action = new Observation(this.action().type(), this.action().fqn(), this.action().props());
        }
        return new Reaction(event.getPublisher().getService(), event.getPayload().getReactionId(), trigger, action, ZonedDateTime.ofInstant(event.getIdentity().getCreated(), ZoneId.systemDefault()));
    }
}

