/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.service.test;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.reaction.observer.event.identified.ActionOnly;
import ch.admin.bit.jeap.reaction.observer.event.identified.Observation;
import ch.admin.bit.jeap.reaction.observer.event.identified.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedPayload;
import ch.admin.bit.jeap.reaction.observer.event.identified.TriggerOnly;
import ch.admin.bit.jeap.reaction.observer.service.test.model.TestObservation;
import ch.admin.bit.jeap.reaction.observer.service.test.model.TestReaction;
import java.util.Map;

public class ReactionIdentifiedEventBuilder
extends AvroDomainEventBuilder<ReactionIdentifiedEventBuilder, ReactionIdentifiedEvent> {
    private final String serviceName;
    private final String systemName;
    private TestReaction reaction;

    public static ReactionIdentifiedEvent buildEvent(String systemName, String serviceName, TestReaction reaction) {
        ReactionIdentifiedEventBuilder builder = new ReactionIdentifiedEventBuilder(serviceName, systemName);
        builder.setReaction(reaction);
        return builder.build();
    }

    private void setReaction(TestReaction reaction) {
        if (reaction.action() == null && reaction.trigger() == null) {
            throw new IllegalArgumentException("Reaction must have at least an action or a trigger");
        }
        this.reaction = reaction;
        this.idempotenceId("ri_" + reaction.id());
    }

    private ReactionIdentifiedEventBuilder(String serviceName, String systemName) {
        super(ReactionIdentifiedEvent::new);
        this.serviceName = serviceName;
        this.systemName = systemName;
    }

    public ReactionIdentifiedEvent build() {
        TriggerOnly reactionPayload;
        if (this.reaction.action() == null) {
            Observation observation = this.createObservation(this.reaction.trigger());
            reactionPayload = new TriggerOnly(observation);
        } else if (this.reaction.trigger() == null) {
            Observation observation = this.createObservation(this.reaction.action());
            reactionPayload = new ActionOnly(observation);
        } else {
            reactionPayload = new Reaction(this.createObservation(this.reaction.trigger()), this.createObservation(this.reaction.action()));
        }
        this.setPayload((MessagePayload)new ReactionIdentifiedPayload(this.reaction.id(), (Object)reactionPayload));
        return (ReactionIdentifiedEvent)super.build();
    }

    private Observation createObservation(TestObservation observation) {
        Map<String, String> props = observation.props();
        if (props == null) {
            props = Map.of();
        }
        return new Observation(observation.type(), observation.fqn(), props);
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected String getSystemName() {
        return this.systemName;
    }

    protected ReactionIdentifiedEventBuilder self() {
        return this;
    }
}

