/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.service.test;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ActionOnly;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.Observation;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ReactionIdentifiedPayload;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.TriggerOnly;
import ch.admin.bit.jeap.reaction.observer.service.test.model.TestObservation;
import ch.admin.bit.jeap.reaction.observer.service.test.model.TestReaction;
import java.util.List;
import java.util.Map;

public class ReactionIdentifiedV2EventBuilder
extends AvroDomainEventBuilder<ReactionIdentifiedV2EventBuilder, ReactionIdentifiedEvent> {
    private final String serviceName;
    private final String systemName;
    private TestReaction reaction;

    public static ReactionIdentifiedEvent buildEvent(String systemName, String serviceName, TestReaction reaction) {
        ReactionIdentifiedV2EventBuilder builder = new ReactionIdentifiedV2EventBuilder(serviceName, systemName);
        builder.setReaction(reaction);
        return builder.build();
    }

    private void setReaction(TestReaction reaction) {
        if ((reaction.actions() == null || reaction.actions().isEmpty()) && reaction.trigger() == null) {
            throw new IllegalArgumentException("Reaction must have at least an action or a trigger");
        }
        this.reaction = reaction;
        this.idempotenceId("ri_" + reaction.id());
    }

    private ReactionIdentifiedV2EventBuilder(String serviceName, String systemName) {
        super(ReactionIdentifiedEvent::new);
        this.serviceName = serviceName;
        this.systemName = systemName;
    }

    public ReactionIdentifiedEvent build() {
        TriggerOnly reactionPayload;
        if (this.reaction.actions() == null || this.reaction.actions().isEmpty()) {
            Observation observation = this.createObservation(this.reaction.trigger());
            reactionPayload = new TriggerOnly(this.reaction.id(), observation);
        } else if (this.reaction.trigger() == null) {
            Observation observation = this.createObservation(this.reaction.actions().getFirst());
            reactionPayload = new ActionOnly(this.reaction.id(), observation);
        } else {
            reactionPayload = new Reaction(this.reaction.id(), this.createObservation(this.reaction.trigger()), this.createObservations(this.reaction.actions()));
        }
        this.setPayload((MessagePayload)new ReactionIdentifiedPayload((Object)reactionPayload));
        return (ReactionIdentifiedEvent)super.build();
    }

    private Observation createObservation(TestObservation observation) {
        Map<String, String> props = observation.props();
        if (props == null) {
            props = Map.of();
        }
        return new Observation(observation.id(), observation.type(), observation.fqn(), props);
    }

    private List<Observation> createObservations(List<TestObservation> observations) {
        return observations.stream().map(this::createObservation).toList();
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected String getSystemName() {
        return this.systemName;
    }

    protected ReactionIdentifiedV2EventBuilder self() {
        return this;
    }
}

