/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.test;

import ch.admin.bit.jeap.messaging.kafka.test.TestKafkaListener;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ActionOnly;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.Reaction;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.identified.v2.TriggerOnly;
import ch.admin.bit.jeap.reaction.observer.event.observed.ReactionsObservedEvent;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactionEventsTestConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionEventsTestConsumer.class);
    private final Map<String, ReactionIdentifiedEvent> reactionIdentifiedEvents = new HashMap<String, ReactionIdentifiedEvent>();
    private final List<ReactionsObservedEvent> reactionsObservedEvents = new ArrayList<ReactionsObservedEvent>();

    @TestKafkaListener(topics={"reaction-identified"})
    void onReactionIdentifiedEvent(ReactionIdentifiedEvent event) {
        log.info("Received reaction identified event: {}", (Object)event);
        this.reactionIdentifiedEvents.put(event.getIdentity().getIdempotenceId(), event);
    }

    @TestKafkaListener(topics={"reactions-observed"})
    void onReactionIdentifiedEvent(ReactionsObservedEvent event) {
        log.info("Received reactions observed event: {}", (Object)event);
        this.reactionsObservedEvents.add(event);
    }

    public ReactionIdentifiedEvent awaitReactionIdentifiedEventForReactionId(String reactionId) {
        log.info("Waiting for reaction identified event with reactionId: {}", (Object)reactionId);
        Predicate<ReactionIdentifiedEvent> predicate = event -> {
            Object object = event.getPayload().getReaction();
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TriggerOnly.class, ActionOnly.class, Reaction.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    TriggerOnly triggerOnly = (TriggerOnly)selector0$temp;
                    yield triggerOnly.getReactionId().equals(reactionId);
                }
                case 1 -> {
                    ActionOnly actionOnly = (ActionOnly)selector0$temp;
                    yield actionOnly.getReactionId().equals(reactionId);
                }
                case 2 -> {
                    Reaction reaction = (Reaction)selector0$temp;
                    yield reaction.getReactionId().equals(reactionId);
                }
                default -> throw new IllegalStateException("Unexpected reaction payload type: " + String.valueOf(event.getPayload().getReaction()));
            };
        };
        Awaitility.await().until(() -> this.reactionIdentifiedEvents.values().stream().anyMatch(predicate));
        return this.reactionIdentifiedEvents.values().stream().filter(predicate).findFirst().orElseThrow();
    }

    public List<ReactionsObservedEvent> awaitReactionsObservedEvents() {
        Awaitility.await().until(() -> !this.reactionsObservedEvents.isEmpty());
        return new ArrayList<ReactionsObservedEvent>(this.reactionsObservedEvents);
    }

    public ReactionsObservedEvent awaitReactionsObservedEventForReactionId(String reactionId) {
        log.info("Waiting for reactions observed event with reactionId: {}", (Object)reactionId);
        Predicate<ReactionsObservedEvent> predicate = event -> event.getPayload().getObservations().stream().anyMatch(observation -> observation.getReactionId().equals(reactionId));
        Awaitility.await().until(() -> this.reactionsObservedEvents.stream().anyMatch(predicate));
        return this.reactionsObservedEvents.stream().filter(predicate).findFirst().orElseThrow();
    }

    @Generated
    public Map<String, ReactionIdentifiedEvent> getReactionIdentifiedEvents() {
        return this.reactionIdentifiedEvents;
    }

    static {
        Awaitility.setDefaultTimeout((Duration)Duration.ofSeconds(30L));
    }
}

