/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.test;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProvider;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.test.KafkaIntegrationTestBase;
import java.time.Duration;
import java.util.HashMap;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeAll;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@SpringBootTest
public abstract class ReactionKafkaTestBase
extends KafkaIntegrationTestBase {
    @Autowired
    private KafkaProperties kafkaProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @BeforeAll
    static void beforeAll() {
        Awaitility.setDefaultTimeout((Duration)Duration.ofSeconds(30L));
    }

    protected void sendTestEventWithoutRecordingAction(String topic, AvroMessage event) {
        String serdeProviderBeanName = new JeapKafkaBeanNames(this.kafkaProperties.getDefaultClusterName()).getKafkaAvroSerdeProviderBeanName(this.kafkaProperties.getDefaultClusterName());
        KafkaAvroSerdeProvider kafkaAvroSerdeProvider = (KafkaAvroSerdeProvider)this.applicationContext.getBean(serdeProviderBeanName);
        byte[] bytes = kafkaAvroSerdeProvider.getValueSerializer().serialize(topic, (Object)event);
        this.createByteArrayKafkaTemplate().send(topic, (Object)bytes);
    }

    private KafkaTemplate<byte[], byte[]> createByteArrayKafkaTemplate() {
        ProducerFactory producerFactory = (ProducerFactory)this.applicationContext.getBean(ProducerFactory.class);
        HashMap producerFactoryConfig = new HashMap(producerFactory.getConfigurationProperties());
        producerFactoryConfig.remove("interceptor.classes");
        return new KafkaTemplate((ProducerFactory)new DefaultKafkaProducerFactory(producerFactoryConfig, this::byteArraySerializer, this::byteArraySerializer));
    }

    private Serializer<byte[]> byteArraySerializer() {
        return new ByteArraySerializer();
    }
}

