/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.test;

import ch.admin.bit.jeap.messaging.kafka.test.TestKafkaListener;
import ch.admin.bit.jeap.reaction.observer.event.identified.ReactionIdentifiedEvent;
import ch.admin.bit.jeap.reaction.observer.event.observed.ReactionsObservedEvent;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactionEventsTestConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionEventsTestConsumer.class);
    private final Map<String, ReactionIdentifiedEvent> reactionIdentifiedEvents = new HashMap<String, ReactionIdentifiedEvent>();
    private final List<ReactionsObservedEvent> reactionsObservedEvents = new ArrayList<ReactionsObservedEvent>();

    @TestKafkaListener(topics={"reaction-identified"})
    void onReactionIdentifiedEvent(ReactionIdentifiedEvent event) {
        log.info("Received reaction identified event: {}", (Object)event);
        this.reactionIdentifiedEvents.put(event.getIdentity().getIdempotenceId(), event);
    }

    @TestKafkaListener(topics={"reactions-observed"})
    void onReactionIdentifiedEvent(ReactionsObservedEvent event) {
        log.info("Received reactions observed event: {}", (Object)event);
        this.reactionsObservedEvents.add(event);
    }

    public ReactionIdentifiedEvent awaitReactionIdentifiedEventForReaction(String reactionIdPattern) {
        Predicate<ReactionIdentifiedEvent> predicate = event -> event.getPayload().getReactionId().matches(reactionIdPattern);
        Awaitility.await().until(() -> this.reactionIdentifiedEvents.values().stream().anyMatch(predicate));
        return this.reactionIdentifiedEvents.values().stream().filter(predicate).findFirst().orElseThrow();
    }

    public List<ReactionsObservedEvent> awaitReactionsObservedEvents() {
        Awaitility.await().until(() -> !this.reactionsObservedEvents.isEmpty());
        return new ArrayList<ReactionsObservedEvent>(this.reactionsObservedEvents);
    }

    public ReactionsObservedEvent awaitReactionsObservedEventForReaction(String reactionIdPattern) {
        Predicate<ReactionsObservedEvent> predicate = event -> event.getPayload().getObservations().stream().anyMatch(observation -> observation.getReactionId().matches(reactionIdPattern));
        Awaitility.await().until(() -> this.reactionsObservedEvents.stream().anyMatch(predicate));
        return this.reactionsObservedEvents.stream().filter(predicate).findFirst().orElseThrow();
    }

    @Generated
    public Map<String, ReactionIdentifiedEvent> getReactionIdentifiedEvents() {
        return this.reactionIdentifiedEvents;
    }

    static {
        Awaitility.setDefaultTimeout((Duration)Duration.ofSeconds(30L));
    }
}

