/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.api;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionsAggregatedRepository;
import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionsAggregatedStatistics;
import ch.admin.bit.jeap.reaction.observer.web.config.ReactionObserverProperties;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class StatisticsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsController.class);
    private final ReactionObserverProperties properties;
    private final ObservedReactionsAggregatedRepository observedReactionsAggregatedRepository;

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get statistics")
    @GetMapping(value={"/statistics/{component}"})
    public ResponseEntity<List<ObservedReactionsAggregatedStatistics>> getStatisticsForComponent(@PathVariable String component) {
        return ResponseEntity.ok((Object)this.observedReactionsAggregatedRepository.getStatistics(component, LocalDate.now().minusDays(this.properties.getStatisticsPeriodInDays())));
    }

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get statistics")
    @GetMapping(value={"/statisticsV2/{component}"})
    public ResponseEntity<List<ObservedReactionsAggregatedStatistics>> getStatisticsV2ForComponent(@PathVariable String component) {
        return this.getStatisticsForComponent(component);
    }

    @Generated
    public StatisticsController(ReactionObserverProperties properties, ObservedReactionsAggregatedRepository observedReactionsAggregatedRepository) {
        this.properties = properties;
        this.observedReactionsAggregatedRepository = observedReactionsAggregatedRepository;
    }
}

