/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.service;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionRepository;
import ch.admin.bit.jeap.reaction.observer.domain.aggregation.AggregationService;
import ch.admin.bit.jeap.reaction.observer.domain.aggregation.TimeUtils;
import ch.admin.bit.jeap.reaction.observer.web.config.ReactionObserverProperties;
import io.micrometer.core.annotation.Timed;
import java.time.LocalDate;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockAssert;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTasksService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledTasksService.class);
    private final AggregationService aggregationService;
    private final ObservedReactionRepository observedReactionRepository;
    private final ReactionObserverProperties properties;

    @Timed(value="reaction_observer_service_aggregate_data")
    @SchedulerLock(name="data-aggregation-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Scheduled(cron="${jeap.reaction.observer.service.data-aggregation-cron-expression}")
    public void aggregateData() {
        log.info("Starting scheduled data aggregation");
        LockAssert.assertLocked();
        LocalDate yesterday = TimeUtils.getToday().minusDays(1L);
        this.aggregationService.aggregateData(yesterday);
        log.info("Finished scheduled data aggregation");
    }

    @SchedulerLock(name="observedreactions-housekeeping-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Scheduled(cron="${jeap.reaction.observer.service.housekeeping-observed-reactions-cron-expression}")
    public void cleanUpObservedReactions() {
        log.info("Starting scheduled housekeeping for observed reactions");
        LockAssert.assertLocked();
        this.observedReactionRepository.deleteByTimeframeStartBefore(TimeUtils.getStartOfDay());
        log.info("Finished scheduled housekeeping for observed reactions");
    }

    @SchedulerLock(name="aggregated-data-housekeeping-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Scheduled(cron="${jeap.reaction.observer.service.housekeeping-aggregated-data-cron-expression}")
    public void cleanUpAggregatedData() {
        log.info("Starting scheduled housekeeping for aggregated data");
        LockAssert.assertLocked();
        this.aggregationService.deleteAggregatedDataOlderThan(TimeUtils.getToday().minusDays(this.properties.getStatisticsPeriodInDays()));
        log.info("Finished scheduled housekeeping for aggregated data");
    }

    @Generated
    public ScheduledTasksService(AggregationService aggregationService, ObservedReactionRepository observedReactionRepository, ReactionObserverProperties properties) {
        this.aggregationService = aggregationService;
        this.observedReactionRepository = observedReactionRepository;
        this.properties = properties;
    }
}

