/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.api;

import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.web.GraphHolder;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.GraphDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.GraphWithFingerprintDto;
import ch.admin.bit.jeap.reaction.observer.web.service.GraphDtoMapper;
import ch.admin.bit.jeap.reaction.observer.web.service.GraphFingerprintCalculator;
import io.swagger.v3.oas.annotations.Operation;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class GraphController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphController.class);
    private final GraphHolder graphHolder;
    private final GraphFingerprintCalculator fingerprintCalculator;

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get graph")
    @GetMapping(value={"/graphs"})
    public ResponseEntity<GraphWithFingerprintDto> getAllReactionsGraph() {
        Graph domainGraph = this.graphHolder.getGraph();
        GraphDto graphDto = GraphDtoMapper.map(domainGraph);
        String fingerprint = this.fingerprintCalculator.calculate(graphDto);
        GraphWithFingerprintDto response = new GraphWithFingerprintDto(graphDto, fingerprint);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public GraphController(GraphHolder graphHolder, GraphFingerprintCalculator fingerprintCalculator) {
        this.graphHolder = graphHolder;
        this.fingerprintCalculator = fingerprintCalculator;
    }
}

