/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.service;

import ch.admin.bit.jeap.reaction.observer.domain.ObservedReactionRepository;
import ch.admin.bit.jeap.reaction.observer.domain.ReactionGraphBuilderService;
import ch.admin.bit.jeap.reaction.observer.domain.aggregation.AggregationService;
import ch.admin.bit.jeap.reaction.observer.domain.aggregation.TimeUtils;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.web.GraphHolder;
import ch.admin.bit.jeap.reaction.observer.web.config.ReactionObserverProperties;
import io.micrometer.core.annotation.Timed;
import jakarta.annotation.PostConstruct;
import java.time.LocalDate;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockAssert;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTasksService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledTasksService.class);
    private final AggregationService aggregationService;
    private final ObservedReactionRepository observedReactionRepository;
    private final ReactionObserverProperties properties;
    private final ReactionGraphBuilderService graphBuilder;
    private final GraphHolder graphHolder;

    @PostConstruct
    public void init() {
        log.info("Initial graph refresh on startup (no lock)");
        this.refreshReactionGraphInternal();
    }

    @SchedulerLock(name="reaction-graph-refresh-task", lockAtLeastFor="5s", lockAtMostFor="30m")
    @Timed(value="reaction_observer_service_reaction_graph_refresh")
    @Scheduled(cron="${jeap.reaction.observer.service.graph-refresh-cron-expression}")
    public void scheduledRefreshReactionGraph() {
        log.info("Starting scheduled reaction graph refresh");
        LockAssert.assertLocked();
        this.refreshReactionGraphInternal();
        log.info("Finished scheduled reaction graph refresh");
    }

    public void refreshReactionGraphInternal() {
        Graph graph = this.graphBuilder.buildGraph(LocalDate.now().minusDays(this.properties.getStatisticsPeriodInDays()));
        this.graphHolder.setGraph(graph);
    }

    @Timed(value="reaction_observer_service_aggregate_data")
    @SchedulerLock(name="data-aggregation-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Scheduled(cron="${jeap.reaction.observer.service.data-aggregation-cron-expression}")
    public void aggregateData() {
        log.info("Starting scheduled data aggregation");
        LockAssert.assertLocked();
        LocalDate yesterday = TimeUtils.getToday().minusDays(1L);
        this.aggregationService.aggregateData(yesterday);
        log.info("Finished scheduled data aggregation");
    }

    @SchedulerLock(name="observedreactions-housekeeping-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Scheduled(cron="${jeap.reaction.observer.service.housekeeping-observed-reactions-cron-expression}")
    public void cleanUpObservedReactions() {
        log.info("Starting scheduled housekeeping for observed reactions");
        LockAssert.assertLocked();
        this.observedReactionRepository.deleteByTimeframeStartBefore(TimeUtils.getStartOfDay());
        log.info("Finished scheduled housekeeping for observed reactions");
    }

    @SchedulerLock(name="aggregated-data-housekeeping-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Scheduled(cron="${jeap.reaction.observer.service.housekeeping-aggregated-data-cron-expression}")
    public void cleanUpAggregatedData() {
        log.info("Starting scheduled housekeeping for aggregated data");
        LockAssert.assertLocked();
        this.aggregationService.deleteAggregatedDataOlderThan(TimeUtils.getToday().minusDays(this.properties.getStatisticsPeriodInDays()));
        log.info("Finished scheduled housekeeping for aggregated data");
    }

    @Generated
    public ScheduledTasksService(AggregationService aggregationService, ObservedReactionRepository observedReactionRepository, ReactionObserverProperties properties, ReactionGraphBuilderService graphBuilder, GraphHolder graphHolder) {
        this.aggregationService = aggregationService;
        this.observedReactionRepository = observedReactionRepository;
        this.properties = properties;
        this.graphBuilder = graphBuilder;
        this.graphHolder = graphHolder;
    }
}

