/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.api;

import ch.admin.bit.jeap.reaction.observer.domain.aggregation.AggregationService;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/management"})
public class ManagementController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagementController.class);
    private final AggregationService aggregationService;

    @PreAuthorize(value="hasAnyRole('reaction-observer-write')")
    @Operation(summary="Aggregate data for a date in format yyyy-mm-dd.")
    @GetMapping(value={"/aggregate-data/{date}"})
    public String aggregateData(@PathVariable String date) {
        try {
            this.aggregationService.aggregateData(LocalDate.parse(date));
            log.info("Data aggregation completed for date: {}", (Object)date);
            return "Data aggregation completed";
        }
        catch (Exception e) {
            log.error("Error aggregating data for date {}: {}", (Object)date, (Object)e.getMessage());
            return "Error aggregating data: " + e.getMessage();
        }
    }

    @Generated
    public ManagementController(AggregationService aggregationService) {
        this.aggregationService = aggregationService;
    }
}

