/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.service;

import ch.admin.bit.jeap.reaction.observer.web.models.graph.EdgeDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.GraphDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.NodeDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.erdtman.jcs.JsonCanonicalizer;
import org.springframework.stereotype.Component;

@Component
public class GraphFingerprintCalculator {
    private final ObjectMapper objectMapper;

    public String calculate(GraphDto dto) {
        try {
            List<NodeDto> sortedNodes = dto.nodes().stream().sorted(Comparator.comparing(NodeDto::getCanonicalId)).toList();
            List<EdgeDto> sortedEdges = dto.edges().stream().sorted(Comparator.comparing(EdgeDto::getCanonicalId)).toList();
            GraphDto sortedDto = new GraphDto(sortedNodes, sortedEdges);
            String json = this.objectMapper.writeValueAsString((Object)sortedDto);
            String canonicalJson = new JsonCanonicalizer(json).getEncodedString();
            return DigestUtils.sha256Hex((String)canonicalJson);
        }
        catch (Exception e) {
            throw new RuntimeException("Fingerprint calculation failed", e);
        }
    }

    @Generated
    public GraphFingerprintCalculator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

