/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.config;

import jakarta.servlet.DispatcherType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableMethodSecurity
public class WebSecurityConfig {
    @Value(value="${jeap.reaction.observer.read-user.username}")
    private String readUserUsername;
    @Value(value="${jeap.reaction.observer.read-user.password}")
    private String readUserPassword;
    @Value(value="${jeap.reaction.observer.write-user.username}")
    private String writeUserUsername;
    @Value(value="${jeap.reaction.observer.write-user.password}")
    private String writeUserPassword;

    @Bean
    @Order(value=-2147483637)
    SecurityFilterChain apiSecurityFilterChain(HttpSecurity http) throws Exception {
        http.securityMatcher(new String[]{"/api/**", "/error"}).csrf(AbstractHttpConfigurer::disable).sessionManagement(management -> management.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).httpBasic(Customizer.withDefaults()).authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(HttpMethod.GET, new String[]{"/api/**"})).permitAll().dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ERROR})).permitAll().anyRequest()).hasAnyRole(new String[]{"reaction-observer-write", "reaction-observer-read"}));
        http.authenticationManager(this.createApiAuthManager((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)));
        return (SecurityFilterChain)http.build();
    }

    private AuthenticationManager createApiAuthManager(AuthenticationManagerBuilder auth) throws Exception {
        ((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().withUser(this.readUserUsername).password(this.readUserPassword).roles(new String[]{"reaction-observer-read"}).and()).withUser(this.writeUserUsername).password(this.writeUserPassword).roles(new String[]{"reaction-observer-write"});
        return (AuthenticationManager)auth.build();
    }
}

