/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.api;

import ch.admin.bit.jeap.reaction.observer.domain.SystemRepository;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SystemController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private final SystemRepository systemRepository;

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get system names", description="Get all system names for which reactions are observed.")
    @GetMapping(value={"/systems/names"})
    public ResponseEntity<List<String>> getSystemNames() {
        return ResponseEntity.ok(this.systemRepository.getSystemNames().stream().filter(Objects::nonNull).toList());
    }

    @Generated
    public SystemController(SystemRepository systemRepository) {
        this.systemRepository = systemRepository;
    }
}

