/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.api;

import ch.admin.bit.jeap.reaction.observer.domain.GraphExtractor;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Message;
import ch.admin.bit.jeap.reaction.observer.web.GraphHolder;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.GraphDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.GraphWithFingerprintDto;
import ch.admin.bit.jeap.reaction.observer.web.service.GraphDtoMapper;
import ch.admin.bit.jeap.reaction.observer.web.service.GraphFingerprintCalculator;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class GraphController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphController.class);
    private final GraphHolder graphHolder;
    private final GraphFingerprintCalculator fingerprintCalculator;
    private final GraphExtractor graphExtractor;

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get all reactions graph")
    @GetMapping(value={"/graphs"})
    public ResponseEntity<GraphWithFingerprintDto> getAllReactionsGraph() {
        Graph domainGraph = this.graphHolder.getGraph();
        GraphDto graphDto = GraphDtoMapper.map(domainGraph);
        String fingerprint = this.fingerprintCalculator.calculate(graphDto);
        GraphWithFingerprintDto response = new GraphWithFingerprintDto(graphDto, fingerprint);
        return ResponseEntity.ok((Object)response);
    }

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get graph for a system")
    @GetMapping(value={"/graphs/systems/{systemName}"})
    public ResponseEntity<GraphWithFingerprintDto> getSystemRelatedGraph(@PathVariable String systemName) {
        Graph domainGraph = this.graphHolder.getGraph();
        Graph systemGraph = this.graphExtractor.getSystemRelatedGraph(domainGraph, systemName);
        if (systemGraph.nodes().isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        GraphDto systemGraphDto = GraphDtoMapper.map(systemGraph);
        String fingerprint = this.fingerprintCalculator.calculate(systemGraphDto);
        GraphWithFingerprintDto response = new GraphWithFingerprintDto(systemGraphDto, fingerprint);
        return ResponseEntity.ok((Object)response);
    }

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get graph for a component")
    @GetMapping(value={"/graphs/components/{componentName}"})
    public ResponseEntity<GraphWithFingerprintDto> getComponentRelatedGraph(@PathVariable String componentName) {
        Graph domainGraph = this.graphHolder.getGraph();
        Graph componentGraph = this.graphExtractor.getComponentRelatedGraph(domainGraph, componentName);
        if (componentGraph.nodes().isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        GraphDto componentGraphDto = GraphDtoMapper.map(componentGraph);
        String fingerprint = this.fingerprintCalculator.calculate(GraphDtoMapper.map(componentGraph));
        GraphWithFingerprintDto response = new GraphWithFingerprintDto(componentGraphDto, fingerprint);
        return ResponseEntity.ok((Object)response);
    }

    @PreAuthorize(value="hasAnyRole('reaction-observer-read')")
    @Operation(summary="Get variant graphs for a message type")
    @GetMapping(value={"/graphs/messages/{messageType}"})
    public ResponseEntity<Map<String, GraphWithFingerprintDto>> getMessageTypeRelatedGraphs(@PathVariable String messageType) {
        Graph domainGraph = this.graphHolder.getGraph();
        List<String> variants = domainGraph.nodes().stream().filter(node -> {
            Message message;
            return node instanceof Message && (message = (Message)node).messageType().equals(messageType);
        }).map(node -> ((Message)node).variant()).distinct().toList();
        Map<String, GraphWithFingerprintDto> result = variants.stream().collect(Collectors.toMap(variant -> variant == null ? messageType : messageType + "/" + variant, variant -> {
            Graph subgraph = this.graphExtractor.getMessageRelatedGraph(domainGraph, messageType, variant);
            GraphDto dto = GraphDtoMapper.map(subgraph);
            String fingerprint = this.fingerprintCalculator.calculate(dto);
            return new GraphWithFingerprintDto(dto, fingerprint);
        }));
        return ResponseEntity.ok(result);
    }

    @Generated
    public GraphController(GraphHolder graphHolder, GraphFingerprintCalculator fingerprintCalculator, GraphExtractor graphExtractor) {
        this.graphHolder = graphHolder;
        this.fingerprintCalculator = fingerprintCalculator;
        this.graphExtractor = graphExtractor;
    }
}

