/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.web.service;

import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Action;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Graph;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Message;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Reaction;
import ch.admin.bit.jeap.reaction.observer.domain.models.graph.Trigger;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.ActionEdgeDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.EdgeDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.GraphDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.MessageNodeDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.NodeDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.ReactionNodeDto;
import ch.admin.bit.jeap.reaction.observer.web.models.graph.TriggerEdgeDto;
import java.util.List;

public class GraphDtoMapper {
    public static GraphDto map(Graph domainGraph) {
        List<NodeDto> nodes = domainGraph.nodes().stream().map(node -> {
            if (node instanceof Message) {
                Message message = (Message)node;
                return MessageNodeDto.from(message);
            }
            if (node instanceof Reaction) {
                Reaction reaction = (Reaction)node;
                return ReactionNodeDto.from(reaction);
            }
            throw new IllegalArgumentException("Unknown node type: " + String.valueOf(node.getClass()));
        }).map(arg_0 -> GraphDtoMapper.lambda$map$1(NodeDto.class, arg_0)).toList();
        List<EdgeDto> edges = domainGraph.edges().stream().map(edge -> {
            if (edge instanceof Trigger) {
                Trigger trigger = (Trigger)edge;
                return TriggerEdgeDto.from(trigger);
            }
            if (edge instanceof Action) {
                Action action = (Action)edge;
                return ActionEdgeDto.from(action);
            }
            throw new IllegalArgumentException("Unknown edge type: " + String.valueOf(edge.getClass()));
        }).map(arg_0 -> GraphDtoMapper.lambda$map$3(EdgeDto.class, arg_0)).toList();
        return new GraphDto(nodes, edges);
    }

    private static /* synthetic */ EdgeDto lambda$map$3(Class rec$, Object x$0) {
        return (EdgeDto)rec$.cast(x$0);
    }

    private static /* synthetic */ NodeDto lambda$map$1(Class rec$, Object x$0) {
        return (NodeDto)rec$.cast(x$0);
    }
}

