/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.messaging;

import ch.admin.bit.jeap.command.notify.client.NotifyClientCommand;
import ch.admin.bit.jeap.command.notify.client.NotifyClientCommandType;
import ch.admin.bit.jeap.server.sent.events.domain.ResourceMutationEvent;
import ch.admin.bit.jeap.server.sent.events.domain.ResourceMutationEventHandler;
import ch.admin.bit.jeap.server.sent.events.domain.ResourceMutationType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;

public class NotifyClientCommandConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotifyClientCommandConsumer.class);
    private final ResourceMutationEventHandler resourceMutationEventHandler;

    @KafkaListener(topics={"${jeap.sse.kafka.topic}"}, id="${spring.application.name}-${random.uuid}")
    public void consume(NotifyClientCommand notifyClientCommand) {
        String sendingApplication = notifyClientCommand.getPublisher().getService();
        NotifyClientCommandType type = notifyClientCommand.getPayload().getType();
        String resourcePath = notifyClientCommand.getReferences().getResourceReference().getResourcePath();
        ResourceMutationType mutationType = this.convertToMutationType(type);
        log.trace("Received NotifyClientCommand from application: {}, type: {}, resourcePath: {}", new Object[]{sendingApplication, mutationType, resourcePath});
        this.resourceMutationEventHandler.resourceMutation(new ResourceMutationEvent(sendingApplication, mutationType, resourcePath));
    }

    private ResourceMutationType convertToMutationType(NotifyClientCommandType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case NotifyClientCommandType.RESOURCE_CREATED -> ResourceMutationType.RESOURCE_CREATED;
            case NotifyClientCommandType.RESOURCE_UPDATED -> ResourceMutationType.RESOURCE_UPDATED;
            case NotifyClientCommandType.RESOURCE_DELETED -> ResourceMutationType.RESOURCE_DELETED;
        };
    }

    @Generated
    public NotifyClientCommandConsumer(ResourceMutationEventHandler resourceMutationEventHandler) {
        this.resourceMutationEventHandler = resourceMutationEventHandler;
    }
}

