/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.server.sent.events.messaging;

import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaAdmin;

public class NotifyClientTopicValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotifyClientTopicValidator.class);
    private final String topicName;
    private final KafkaAdmin kafkaAdmin;

    @PostConstruct
    public void checkIfTopicsExist() throws ExecutionException, InterruptedException {
        try (AdminClient adminClient = AdminClient.create((Map)this.kafkaAdmin.getConfigurationProperties());){
            List<String> topics = Collections.singletonList(this.topicName);
            log.info("Checking if topic exists: {}", topics);
            Map stringTopicDescriptionMap = (Map)adminClient.describeTopics(topics).allTopicNames().get();
            stringTopicDescriptionMap.forEach((name, desc) -> log.info("{}: {}", name, desc));
            log.info("Topic exists, good to go");
        }
    }

    @Generated
    public NotifyClientTopicValidator(String topicName, KafkaAdmin kafkaAdmin) {
        this.topicName = topicName;
        this.kafkaAdmin = kafkaAdmin;
    }
}

